package org.apache.log4j.appender;

import junit.framework.Assert;
import junit.framework.TestCase;

public class TestTimeBasedRoller extends TestCase {

  public void testTimeBasedRollerMinutes() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setDatePattern("mm");
    TimeBasedRoller roller = new TimeBasedRoller(appender, properties);
    Assert.assertEquals(TimeBasedRollStrategy.ROLL_EACH_MINUTE, roller.getRollStrategy());
  }

  public void testTimeBasedRollerEmptyDatePattern() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setDatePattern("");
    TimeBasedRoller roller = new TimeBasedRoller(appender, properties);
    Assert.assertEquals(TimeBasedRollStrategy.ROLL_EACH_DAY, roller.getRollStrategy()); // default
  }

  public void testTimeBasedRollerNullDatePattern() {
    TimeAndSizeRollingAppender appender = new TimeAndSizeRollingAppender();
    appender.setName("testAppender");
    AppenderRollingProperties properties = new AppenderRollingProperties();
    properties.setDatePattern(null);
    TimeBasedRoller roller = new TimeBasedRoller(appender, properties);
    Assert.assertEquals(TimeBasedRollStrategy.ROLL_EACH_DAY, roller.getRollStrategy()); // default
  }

}
