/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.management.FileSystem;

public class FileSystemImpl
extends FileSystem {
    @Override
    public boolean supportsFileSecurity(File f) throws IOException {
        return FileSystemImpl.isSecuritySupported0(f.getAbsolutePath());
    }

    @Override
    public boolean isAccessUserOnly(File f) throws IOException {
        String path = f.getAbsolutePath();
        if (!FileSystemImpl.isSecuritySupported0(path)) {
            throw new UnsupportedOperationException("File system does not support file security");
        }
        return FileSystemImpl.isAccessUserOnly0(path);
    }

    static native void init0();

    static native boolean isSecuritySupported0(String var0) throws IOException;

    static native boolean isAccessUserOnly0(String var0) throws IOException;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("management");
                return null;
            }
        });
        FileSystemImpl.init0();
    }
}

