/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;

public class VRMUpdate3897Command
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 1;
        byte slaveAddr = 72;
        if (this.parameters == null) {
            MOut.G(this).println("Please specify the psf file path.");
        } else {
            FileReader fr = new FileReader(this.parameters[0]);
            if (fr == null) {
                MOut.G(this).println("Open file fail.");
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            byte[] data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(1000L);
            data = new byte[]{-2, -47, 124, -77};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            BufferedReader br = new BufferedReader(fr);
            boolean isExtend = false;
            while (br.ready()) {
                String s = br.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                value = this.get_data(s);
                data[0] = adress;
                System.arraycopy(value, 0, data, 1, value.length);
                ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            }
            fr.close();
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            Thread.sleep(1000L);
            data = new byte[]{-2, -48, -41, -17};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -95, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -92};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            data = new byte[]{-2, -48, 0, 0};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            MOut.G(this).println("Upload data success");
            MOut.G(this).println("Start Checking data...");
            Thread.sleep(500L);
            FileReader frc = new FileReader(this.parameters[0]);
            if (frc == null) {
                MOut.G(this).println("Open file fail.");
                this.statusCode = 147;
                return;
            }
            BufferedReader brc = new BufferedReader(frc);
            isExtend = false;
            while (brc.ready()) {
                String s = brc.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                byte[] readResult = ipmiI2CPMBusCommand.checkVRMdata(adress);
                value = this.get_data(s);
                MOut.G(this).println("adress: 40" + ByteUtility.byteToHex(adress) + " value: " + ByteUtility.byteToHex(readResult[0]) + " " + ByteUtility.byteToHex(readResult[1]));
                if (Arrays.equals(value, readResult)) continue;
                MOut.G(this).println("Waning: Data of adress " + Integer.toHexString(adress) + " does not match the file");
            }
            frc.close();
            Thread.sleep(1000L);
            MOut.G(this).println("Check VRM data finished....");
            MOut.G(this).println("Please wait for 30s then do the power cycle.");
            this.statusCode = 0;
        }
    }

    public byte get_Adress(String s) {
        byte adress = (byte)Integer.parseInt(s.substring(2, 4), 16);
        return adress;
    }

    public byte[] get_data(String s) {
        byte[] data = new byte[2];
        String str_value = s.substring(5, 21);
        data[1] = (byte)Integer.parseInt(str_value.substring(0, 8), 2);
        data[0] = (byte)Integer.parseInt(str_value.substring(8, 16), 2);
        return data;
    }

    public static void main(String[] args) throws IOException {
        VRMUpdate3897Command vrm = new VRMUpdate3897Command();
        FileReader fr = new FileReader("D:/Program Files/project/MasterWriteRead/CPUs.psf");
        BufferedReader br = new BufferedReader(fr);
        boolean isExtend = false;
        while (br.ready()) {
            String s = br.readLine();
            int notePosition = s.indexOf("/");
            if (notePosition == 0) continue;
            if (notePosition > 0) {
                s = s.substring(0, notePosition);
            }
            if (s.substring(1, 2).contains("1")) {
                isExtend = true;
                continue;
            }
            if (s.length() < 21) continue;
            byte adress = vrm.get_Adress(s);
            byte[] data = vrm.get_data(s);
            System.out.println(adress);
            System.out.println(Integer.toHexString(data[0]) + " " + Integer.toHexString(data[1]));
        }
        fr.close();
    }
}

