/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserLevelCommand
extends SuperBladeCommand {
    byte userID;
    byte privilege;

    @Override
    public boolean preValidate() {
        if (this.config.getPrivilege() != 4) {
            MOut.G(this).println("Your privilege is not enough to do this action");
            return false;
        }
        String usage = "Usage: user level <user id> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
            if (this.userID < 1 || this.userID > 10) {
                MOut.G(this).println("user id should be 1-10");
                MOut.G(this).println(usage);
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be 1-10");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("privilege should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if ((this.privilege < 2 || this.privilege > 4) && this.privilege != 15) {
            MOut.G(this).println("Privilege level error");
            MOut.G(this).println("Administrator level : 4");
            MOut.G(this).println("Operator level      : 3");
            MOut.G(this).println("User level          : 2");
            MOut.G(this).println("No access           : 15");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b1 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, this.privilege);
        if (!b1) {
            MOut.G(this).println("Set user privilege failed");
            this.statusCode = 149;
            return;
        }
        boolean b2 = ipmiMessagingCommand.setEnableUserPlusByID(this.userID, this.privilege);
        if (!b2) {
            MOut.G(this).println("Set enable user(+) failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

