/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIeBayPSUUpdateCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class PSUeBayUpdateCommand
extends SuperBladeCommand {
    private byte slaveAddr;
    private String file;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.usage();
            this.statusCode = 147;
            return false;
        }
        if (this.parameters.length == 2) {
            try {
                this.slaveAddr = (byte)Integer.parseInt(this.parameters[0], 16);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return false;
            }
            this.file = this.parameters[1];
            if (new File(this.file).exists()) {
                return true;
            }
            MOut.G(this).println("File does not exist.");
            this.statusCode = 147;
            return false;
        }
        this.usage();
        this.statusCode = 147;
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        String pubKeyStr = "30820122300d06092a864886f70d01010105000382010f003082010a0282010100dfdb963c5b3ae94d6dcbeaa4f6492d6c6dad0ef6fd778235fc4a088cb42ea9dc66d7b9906c1c7147ab24bf511e3bbb4c94d1642b93f8225d46d5e7caceef5d34bb4c4c4f3f012b1614af6b3ea87d46f32d4887c91a94a772da51a10f85c7fffdfaba38190f44e044d29dcd9a5ae0da4f8af7ec94465e550269b699d2cedad5d28cff07d41b6b80794a7cdf7f85ce829947bc14474dcfb1e17799fdb09ac42fcb13b108225b1307bdce2e2026b5fa8f97b5b7e707b87ab9896039fe2681547cf0a39ca3b695b63c8e1074159bb70eccee983e4a59746fc5e708fd707469736d578f3fda371855241371d1cd7730a6b81c20eebc0d163faf1673ffeb372b9cecfb0203010001";
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(DatatypeConverter.parseHexBinary((String)pubKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Path path = Paths.get(this.file, new String[0]);
        byte[] originalContent = Files.readAllBytes(path);
        byte[] fwContent = Arrays.copyOfRange(originalContent, 0, originalContent.length - 1416);
        byte[] signedContent = Arrays.copyOfRange(originalContent, originalContent.length - 256, originalContent.length);
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(pubKey);
        sig.update(fwContent);
        boolean verified = sig.verify(signedContent);
        if (!verified) {
            MOut.G(this).println("Update package verification failed");
            return;
        }
        MOut.G(this).println("Update package verified");
        boolean flag = false;
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIeBayPSUUpdateCommand psuUpdateCommand = new IPMIeBayPSUUpdateCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiI2CPMBusCommand.detectBusID();
        ipmiI2CPMBusCommand.isUseOEMPsuCmd = ipmiI2CPMBusCommand.checkOEMGetPSUInfoCommand();
        if (ipmiI2CPMBusCommand.isUseOEMPsuCmd) {
            ipmiI2CPMBusCommand.detectSlaveAddressWithPsuIndex();
        } else {
            ipmiI2CPMBusCommand.detectSlaveAddress();
        }
        if (ipmiI2CPMBusCommand.getBusID() == 0) {
            MOut.G(this).println("Cannot detect BusID");
            this.statusCode = 147;
            return;
        }
        if (ipmiI2CPMBusCommand.getAvailableSlaveAddrs() == null) {
            MOut.G(this).println("Cannot detect slave address");
            this.statusCode = 147;
            return;
        }
        if (!psuUpdateCommand.parseFile(this.file)) {
            MOut.G(this).println("File error.");
            this.statusCode = 149;
            return;
        }
        for (int i = 0; i < ipmiI2CPMBusCommand.getAvailableSlaveAddrs().length; ++i) {
            ipmiI2CPMBusCommand.setSlaveAddr(ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i]);
            if (ipmiI2CPMBusCommand.getAvailablePsuIndexs() != null) {
                ipmiI2CPMBusCommand.setPsuIndex(ipmiI2CPMBusCommand.getAvailablePsuIndexs()[i]);
            }
            if (ipmiI2CPMBusCommand.getAvailableSlaveAddrs()[i] != this.slaveAddr) continue;
            String pwsModuleNumber = new String(ipmiI2CPMBusCommand.getPWSModuleNumber()).trim();
            if (pwsModuleNumber.contains("PWS-2K04A") || pwsModuleNumber.contains("PWS-2K20A")) {
                flag = true;
                break;
            }
            MOut.G(this).println("Not support " + pwsModuleNumber + ".");
            this.statusCode = 153;
            return;
        }
        if (!flag) {
            MOut.G(this).println("Slave Address failed.");
            this.statusCode = 147;
            return;
        }
        byte target = (byte)(this.slaveAddr & 0xF);
        MOut.G(this).print("Enter ROM Mode .. ");
        psuUpdateCommand.enterRomMode(target);
        MOut.G(this).println("Done");
        MOut.G(this).print("Determin Device Type and ROM Version\t");
        byte[] version = psuUpdateCommand.determineDeviceTypeAndROMVersion();
        MOut.G(this).println("ROM Version: " + ByteUtility.bcdToInt(version[2]) + "." + ByteUtility.byteToHex(version[1]) + ", IC Version: " + ByteUtility.bcdToInt(version[4]) + "." + ByteUtility.byteToHex(version[3]));
        MOut.G(this).print("Enable Access To Control Registers .. \t");
        psuUpdateCommand.enableAccessToControlRegisters();
        MOut.G(this).println("Done");
        MOut.G(this).print("Enable Access to Trim Flash .. \t\t");
        psuUpdateCommand.enableAccessToTrimFlash();
        MOut.G(this).println("Done");
        MOut.G(this).print("Clear The Info Block Enable Bit .. \t");
        psuUpdateCommand.clearTheInfoBlockEnableBit();
        MOut.G(this).println("Done");
        MOut.G(this).print("Set RAM Location Replace With Zero .. \t");
        psuUpdateCommand.setRAMLocationReplaceWithZero();
        MOut.G(this).println("Done");
        MOut.G(this).print("Erase All of Program Flash Start .. \t");
        psuUpdateCommand.eraseAllOfProgramFlashStart();
        MOut.G(this).println("Done");
        MOut.G(this).print("Start to Program 1 .. \t\t\t");
        psuUpdateCommand.startToProgram();
        MOut.G(this).println("Done");
        MOut.G(this).print("Erase All of Program Flash End .. \t");
        psuUpdateCommand.eraseAllOfProgramFlashEnd();
        MOut.G(this).println("Done");
        MOut.G(this).print("Start to Program 2 .. \t\t\t");
        psuUpdateCommand.startToProgram2();
        MOut.G(this).println("Done");
        MOut.G(this).print("Require Calcurate Checksum .. \t\t");
        psuUpdateCommand.requiredCalculateCheckSum();
        MOut.G(this).println("Done");
        MOut.G(this).print("Checksum\t\t\t\t");
        byte[] checkSum = psuUpdateCommand.getCheckSum();
        MOut.G(this).println("[ " + ByteUtility.bytesToHex(checkSum) + " ]");
        MOut.G(this).print("Set Checksum\t\t\t\t");
        psuUpdateCommand.writeCheckSum(checkSum);
        MOut.G(this).println("Done");
        MOut.G(this).print("Reconfigure .. \t\t\t\t");
        psuUpdateCommand.reconfigure();
        MOut.G(this).println("Done");
        MOut.G(this).println("Update Completed.");
        this.statusCode = 0;
    }

    public void usage() {
        MOut.G(this).println("Usage: psu ebayupdate <slaveAddr> <file>");
    }
}

