/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;

public class IPMIFRUWriteCommand
extends SuperBladeCommand {
    String field;
    String[] values;

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            this.usage();
            return false;
        }
        this.field = this.parameters[0].toUpperCase();
        if (this.field.equals("CT") || this.field.equals("CP") || this.field.equals("CS") || this.field.equals("BDT") || this.field.equals("BM") || this.field.equals("BPN") || this.field.equals("BS") || this.field.equals("BP") || this.field.equals("PM") || this.field.equals("PN") || this.field.equals("PPM") || this.field.equals("PV") || this.field.equals("PS") || this.field.equals("PAT")) {
            if (this.field.equals("CT")) {
                short chassisType;
                if (this.parameters.length == 2 && NumberUtils.isNumber((String)this.parameters[1]) && ((chassisType = Short.parseShort(this.parameters[1], 16)) >= 0 && chassisType <= 32 || chassisType == 39)) {
                    return true;
                }
                MOut.G(this).println("Invalid chassis type.");
                MOut.G(this).println("");
                this.chassTypeUsage();
                return false;
            }
            if (this.field.equals("BDT")) {
                if (this.parameters.length == 2 && this.parameters[1].length() == 12) {
                    return true;
                }
                MOut.G(this).println("Date/Time format error.");
                MOut.G(this).println("");
                MOut.G(this).println("Format: YYYYMMDDhhmm  ex:201007161200 (2010/07/16 12:00)");
                return false;
            }
        } else {
            MOut.G(this).println("Invalid field.");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.field.equals("CT")) {
            ipmiFRUCommand.fruWrite(this.field, new byte[]{Byte.parseByte(this.parameters[1], 16)});
        } else if (this.field.equals("BDT")) {
            byte[] bdtAry = new byte[3];
            Date dt1 = new Date();
            Date dt2 = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyyMMddHHmm");
            try {
                dt1 = sdf.parse("199601010000");
                dt2 = sdf.parse(this.parameters[1]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            long timeValue = (dt2.getTime() - dt1.getTime()) / 60000L;
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, timeValue);
            System.arraycopy(tempAry, 0, bdtAry, 0, bdtAry.length);
            ipmiFRUCommand.fruWrite(this.field, bdtAry);
        } else {
            String str = "";
            if (this.parameters.length > 1) {
                for (int i = 1; i < this.parameters.length; ++i) {
                    str = i == 1 ? this.parameters[i] : str + " " + this.parameters[i];
                }
            }
            if (str.length() > 63) {
                MOut.G(this).println("Data exeed the maximum acceptable length.");
                this.statusCode = 149;
                return;
            }
            ipmiFRUCommand.fruWrite(this.field, str.getBytes());
        }
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
        MOut.G(this).print(fruInfo.toReadableString());
        this.statusCode = 0;
    }

    public void usage() {
        MOut.G(this).println("Usage: fruw <field> <value>");
        MOut.G(this).println("Available Fields for FRU:");
        MOut.G(this).println("  Chassis Info Fields:");
        MOut.G(this).println("    CT  :Chassis Type");
        MOut.G(this).println("    CP  :Chassis Part number");
        MOut.G(this).println("    CS  :Chassis Serial number");
        MOut.G(this).println("  Board Info Fields:");
        MOut.G(this).println("    BDT :Board Mfg. Date/Time (YYYYMMDDhhmm)");
        MOut.G(this).println("    BM  :Board Manufacturer");
        MOut.G(this).println("    BPN :Board Product Name");
        MOut.G(this).println("    BS  :Board Serial Name");
        MOut.G(this).println("    BP  :Board Part Number");
        MOut.G(this).println("  Product Info Fields:");
        MOut.G(this).println("    PM  :Product Manufacturer");
        MOut.G(this).println("    PN  :Product Name");
        MOut.G(this).println("    PPM :Product Part/Model Number");
        MOut.G(this).println("    PV  :Product Version");
        MOut.G(this).println("    PS  :Product Serial Number");
        MOut.G(this).println("    PAT :Asset Tag");
    }

    public void chassTypeUsage() {
        MOut.G(this).println("  01h = Other");
        MOut.G(this).println("  02h = Unknown");
        MOut.G(this).println("  03h = Desktop");
        MOut.G(this).println("  04h = Low Profile Desktop");
        MOut.G(this).println("  05h = Pizza Box");
        MOut.G(this).println("  06h = Mini Tower");
        MOut.G(this).println("  07h = Tower");
        MOut.G(this).println("  08h = Portable");
        MOut.G(this).println("  09h = LapTop");
        MOut.G(this).println("  0Ah = Notebook");
        MOut.G(this).println("  0Bh = Hand Held");
        MOut.G(this).println("  0Ch = Docking Station");
        MOut.G(this).println("  0Dh = All in One");
        MOut.G(this).println("  0Eh = Sub Notebook");
        MOut.G(this).println("  0Fh = Space-saving");
        MOut.G(this).println("  10h = Lunch Box");
        MOut.G(this).println("  11h = Main Server Chassis");
        MOut.G(this).println("  12h = Expansion Chassis");
        MOut.G(this).println("  13h = SubChassis");
        MOut.G(this).println("  14h = Bus Expansion Chassis");
        MOut.G(this).println("  15h = Peripheral Chassis");
        MOut.G(this).println("  16h = RAID Chassis");
        MOut.G(this).println("  17h = Rack Mount Chassis");
        MOut.G(this).println("  18h = Sealed-case PC");
        MOut.G(this).println("  19h = Multi-system chassis");
        MOut.G(this).println("  1Ah = Compact PCI");
        MOut.G(this).println("  1Bh = Advanced TCA");
        MOut.G(this).println("  1Ch = Blade");
        MOut.G(this).println("  1Dh = Blade Enclosure");
        MOut.G(this).println("  1Eh = Tablet");
        MOut.G(this).println("  1Fh = Convertible");
        MOut.G(this).println("  20h = Detachable");
    }
}

