/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import java.util.Arrays;

public class EntryPoint {
    byte[] dataByte;
    byte[] anchorStr;
    byte checksum;
    byte length;
    byte majorVersion;
    byte minorVersion;
    byte docrev;
    byte revision;
    byte reserved;
    byte[] tableMaximum;
    byte[] tableAddress;

    public EntryPoint(byte[] dataByte) {
        this.dataByte = dataByte;
        this.anchorStr = Arrays.copyOfRange(dataByte, 0, 5);
        this.checksum = dataByte[5];
        this.length = dataByte[6];
        this.majorVersion = dataByte[7];
        this.minorVersion = dataByte[8];
        this.docrev = dataByte[9];
        this.revision = dataByte[10];
        this.reserved = dataByte[11];
        this.tableMaximum = Arrays.copyOfRange(dataByte, 12, 16);
        this.tableAddress = Arrays.copyOfRange(dataByte, 16, 24);
    }

    String getAnchorStr() {
        return new String(this.anchorStr);
    }

    String getChecksum() {
        return ByteUtility.byteToHex(this.checksum);
    }

    String getLength() {
        return ByteUtility.byteToHex(this.length);
    }

    String getMajorVersion() {
        return ByteUtility.byteToHex(this.majorVersion);
    }

    String getMinorVersion() {
        return ByteUtility.byteToHex(this.minorVersion);
    }

    String getDocrev() {
        switch (this.docrev) {
            case 0: {
                return "10.22.0";
            }
            case 1: {
                return "2.7.1";
            }
        }
        return null;
    }

    String getRevision() {
        switch (this.revision) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "SMBIOS 3.0";
            }
        }
        return "Reserved";
    }

    int getTableMaximum() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.tableMaximum);
    }

    long getTableAddress() {
        return ByteUtility.eightBytesToLongByLSBFirst(this.tableAddress);
    }

    public byte[] remainBytes() {
        return Arrays.copyOfRange(this.dataByte, (int)this.length, this.dataByte.length);
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %30s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "-------------------------"));
        return header.toString();
    }

    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Structure", "Entry Point"));
        fStr.append(String.format(format, "Anchor String", this.getAnchorStr()));
        fStr.append(String.format(format, "Checksum", "0x" + this.getChecksum()));
        fStr.append(String.format(format, "Length", this.length + " (0x" + this.getLength() + ")"));
        fStr.append(String.format(format, "SMBIOS Version", Integer.parseInt(this.getMajorVersion()) + "." + Integer.parseInt(this.getMinorVersion())));
        fStr.append(String.format(format, "Docrev", this.getDocrev()));
        fStr.append(String.format(format, "Revision", this.getRevision()));
        fStr.append(String.format(format, "Table Maximum", this.getTableMaximum()));
        fStr.append(String.format(format, "Table Address", this.getTableAddress()));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

