/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.dcmi.EnhancedPowerStatAttr;
import java.util.HashMap;
import java.util.Map;

public class GetDCMICapabilityInfo {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMIDCMICommand dcmi;

    public GetDCMICapabilityInfo(IPMIDCMICommand dcmi) {
        this.dcmi = dcmi;
    }

    public EnhancedPowerStatAttr execute() throws IPMIException {
        IPMIMessage resMessage = this.dcmi.getDCMICapInfoCommand((byte)5);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new EnhancedPowerStatAttr(resMessage.data);
            }
            throw Common.cCodeToException(completionCodeToString, resMessage);
        }
        throw new IPMIException("Call GetDCMICapabilityInfo failed");
    }

    static {
        completionCodeToString.put("C1", "Returned if DCMI mode is not present.");
    }
}

