/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.algo;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.algo.IntegrityAlgorithm;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HMAC_SHA1_96
extends IntegrityAlgorithm {
    @Override
    public byte[] code(byte[] key, byte[] plainText) {
        byte[] result = null;
        try {
            Mac hmacSHA1 = Mac.getInstance("HmacSHA1");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacSHA1");
            hmacSHA1.init(sks);
            result = hmacSHA1.doFinal(plainText);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] b1 = new byte[12];
        System.arraycopy(result, 0, b1, 0, 12);
        return b1;
    }

    public static void main(String[] args) throws Exception {
        HMAC_SHA1_96 sha = new HMAC_SHA1_96();
        String key = "SUPERMICRO-IPMI";
        String value = "SMC-201205-BMC_BIOS_UPDATE_TOOL";
        byte[] result = sha.code(key.getBytes(), value.getBytes());
        System.out.println("Key =" + key);
        System.out.println("Value =" + value);
        System.out.println("Private Key= " + ByteUtility.bytesToHex(result));
        for (int i = 0; i < 256; ++i) {
            String macAddress = "0030480000" + String.format("%02X", i);
            System.out.println("MAC Address = " + macAddress + " getByte() =" + ByteUtility.bytesToHex(macAddress.getBytes()));
            result = sha.code(result, macAddress.getBytes());
            System.out.println("result = " + ByteUtility.bytesToHex(result));
            String s = new BASE64Encoder().encode(result);
            System.out.println("base64 encode = " + s);
            System.out.println("base64 decode = " + ByteUtility.bytesToHex(new BASE64Decoder().decodeBuffer(s)));
        }
    }
}

