/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.MCUFactory;
import com.supermicro.ipmi.MCUType;
import com.supermicro.ipmi.MCUUpdateInterface;
import com.supermicro.ipmi.text.MOut;

public class IPMITwinProNXMCUUpdater
extends IPMICommand {
    IPMITwinProCommand ipmiTwinProComm;
    String mcuFirmwareName;
    byte[] mcuFirmware;
    boolean isPassChecking = false;
    MOut mout = MOut.G();

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMITwinProNXMCUUpdater(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiTwinProComm = new IPMITwinProCommand(ipmiInterface);
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiTwinProComm.setIPMIInterface(ipmiInterface);
    }

    public void setMCUFirmwareName(String filename) {
        this.mcuFirmwareName = filename;
    }

    public void setMCUFirmware(byte[] fileByteArray) {
        this.mcuFirmware = fileByteArray;
    }

    public void setPassChecking(boolean value) {
        this.isPassChecking = value;
    }

    public boolean update(byte mcuID) {
        MCUFactory factory = new MCUFactory();
        MCUUpdateInterface mcuInstance = factory.createInstanceByMCUID(mcuID);
        mcuInstance.setIpmiTwinProComm(this.ipmiTwinProComm);
        mcuInstance.setMCUFirmware(this.mcuFirmware);
        mcuInstance.setMout(this.mout);
        try {
            block22: {
                IPMIMessage percentageMessage;
                if (!mcuInstance.verifyFileFormat()) {
                    return false;
                }
                if (!mcuInstance.validatePrerequisites()) {
                    return false;
                }
                if (!this.isPassChecking && !mcuInstance.isNodesShutdown()) {
                    return false;
                }
                this.mout.println("================");
                this.mout.println(" Uploading file");
                this.mout.println("================");
                IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(this.getIPMIInterface());
                IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(ipmiCMMOEMCommand.getIPMIInterface());
                ipmiBMCFileCommand.generalFileUpload((byte)14, this.mcuFirmwareName, false);
                IPMIMessage message = new IPMIMessage();
                int i = 0;
                int targetRate = 0;
                int curRate = 0;
                int updatingTimeout = 300;
                this.mout.println();
                this.mout.println("===============");
                this.mout.println(" Updating file");
                this.mout.println("===============");
                for (i = 0; i < 10; ++i) {
                    message = this.measureMCUUpdateStatus();
                    if (message.completionCode == 0) {
                        if (message.data[0] == 32 || message.data[0] == 4 || message.data[0] == 64 || message.data[0] == -128) {
                            mcuInstance.setMcuType(MCUType.getMCUNameBytValue(message.data[0]));
                            break;
                        }
                        if (i == 9) {
                            this.mout.println("Fail to update MCU.");
                            return false;
                        }
                    } else {
                        this.mout.println("MCU update status: " + ByteUtility.byteToHex(message.completionCode));
                        return false;
                    }
                    Thread.sleep(1000L);
                }
                this.mout.print("Progress:|");
                boolean flag = false;
                i = 0;
                while (true) {
                    if (i > updatingTimeout * 2) {
                        this.mout.println("Timeout, update MCU failed.");
                        return false;
                    }
                    percentageMessage = this.getMCUUpdatePercentage();
                    if (percentageMessage.completionCode != 0) break;
                    byte percentage = percentageMessage.data[0];
                    targetRate = percentage / 3;
                    while (curRate < targetRate) {
                        if (flag) {
                            this.mout.print(">");
                        }
                        flag = true;
                        ++curRate;
                    }
                    if (percentage < 100) {
                        ++i;
                        Thread.sleep(500L);
                        continue;
                    }
                    break block22;
                    break;
                }
                this.mout.println();
                switch (percentageMessage.completionCode) {
                    case -5: {
                        this.mout.println("EC firmware update fail.");
                        break;
                    }
                    case -4: {
                        this.mout.println("EC flash ID mismatch.");
                        break;
                    }
                    case -3: {
                        this.mout.println("Operation fail #9548. (Fail to switch MUX for EC2)");
                        break;
                    }
                    case -2: {
                        this.mout.println("The uploaded file is invalid.");
                        break;
                    }
                    case -1: {
                        this.mout.println("EC firmware does not exists.");
                    }
                }
                this.mout.println("Update fail.");
                return false;
            }
            this.mout.println("| 100%");
            this.mout.println("Update complete.");
            this.mout.println(mcuInstance.notifiyMessage(mcuInstance.getMcuType()));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    IPMIMessage measureMCUUpdateStatus() {
        byte[] data = new byte[]{107};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    IPMIMessage getMCUUpdatePercentage() {
        byte[] data = new byte[]{-127, 0};
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)-64, (byte)112, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }
}

