/*
 * Decompiled with CFR 0.152.
 */
package com.ami.iusb.protocol;

import com.ami.iusb.EncryptionException;
import com.ami.iusb.RedirectionException;
import com.ami.iusb.protocol.RedirPacket;
import com.ami.iusb.protocol.RedirProtocol;
import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.LocaleStrings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class PacketMaster {
    private SocketChannel packetSock;
    private Selector packetSel;
    private RedirProtocol protocol;
    private boolean sslEncryption;
    private SSLEngine engine;
    private SSLSession session;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private boolean debug = false;
    private static final int RECEIVE_TIMEOUT = 60;
    private String host;
    private int port;
    private boolean blocking;
    private boolean wakeup = false;
    private static final int IUSB_HDR_SIZE = 32;

    public PacketMaster(String host, int port, boolean blocking, RedirProtocol protocol, boolean sslEncryption) {
        this.host = host;
        this.port = port;
        this.blocking = blocking;
        this.protocol = protocol;
        this.sslEncryption = sslEncryption;
        if (sslEncryption) {
            this.CreateSSLEngine();
            if (this.engine == null) {
                System.out.println("engine = null");
            } else {
                this.session = this.engine.getSession();
            }
        }
    }

    public void setupBuffers(int inBufferSize, int outBufferSize) {
        if (this.sslEncryption) {
            this.appIn = ByteBuffer.allocateDirect(inBufferSize);
            this.appOut = ByteBuffer.allocateDirect(outBufferSize);
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.debugOut("Allocating SSL network buffers and application buffers");
            this.debugOut("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            this.debugOut("Allocated appOut buffer of " + this.appOut.capacity() + " bytes");
            this.debugOut("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
            this.debugOut("Allocated appIn buffer of " + this.appIn.capacity() + " bytes");
        } else {
            this.netIn = ByteBuffer.allocateDirect(inBufferSize);
            this.netOut = ByteBuffer.allocateDirect(outBufferSize);
            this.appIn = this.netIn;
            this.appOut = this.netOut;
            this.debugOut("No SSL, allocating only netIn and netOut...");
            this.debugOut("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
            this.debugOut("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
        }
    }

    public void setupBuffers(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        if (this.sslEncryption) {
            this.appIn = inBuffer;
            this.appOut = outBuffer;
            this.netIn = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netOut = ByteBuffer.allocateDirect(this.session.getPacketBufferSize());
            this.netIn.order(ByteOrder.LITTLE_ENDIAN);
            this.netOut.order(ByteOrder.LITTLE_ENDIAN);
            this.appIn.clear();
            this.appOut.clear();
            this.debugOut("Using SSL, allocating netIn and netOut buffers");
            this.debugOut("Using provided appIn and appOut buffers");
        } else {
            this.netIn = inBuffer;
            this.netOut = outBuffer;
            this.appIn = this.netIn;
            this.appOut = this.netOut;
            this.netIn.clear();
            this.netOut.clear();
            this.debugOut("No SSL, using provided buffers exclusively");
        }
    }

    public void setBufferEndianness(ByteOrder inByteOrder, ByteOrder outByteOrder) {
        this.appIn.order(inByteOrder);
        this.appOut.order(outByteOrder);
    }

    public void connect() throws IOException {
        try {
            this.packetSock = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (UnresolvedAddressException e) {
            throw new IOException(LocaleStrings.GetString("8_1_PACKETMAST") + this.host);
        }
        if (!this.blocking) {
            this.packetSock.configureBlocking(false);
        }
        this.packetSock.socket().setTcpNoDelay(true);
        this.packetSel = Selector.open();
        this.packetSock.register(this.packetSel, 1);
        if (this.sslEncryption) {
            this.initSSL();
        }
    }

    private void CreateSSLEngine() {
        SSLContext context = null;
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslCtx = SSLContext.getInstance("SSL");
            sslCtx.init(null, trustAllCerts, new SecureRandom());
            context = sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(LocaleStrings.GetString("8_2_PACKETMAST") + e.getMessage());
        }
        catch (KeyManagementException e) {
            System.err.println(LocaleStrings.GetString("8_3_PACKETMAST") + e.getMessage());
        }
        this.engine = context.createSSLEngine();
        this.engine.setUseClientMode(true);
    }

    private void initSSL() throws IOException {
        try {
            this.engine.beginHandshake();
            while (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                Runnable runnable;
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    Debug.out.println("######## NEED_WRAP ################\n");
                    Debug.out.println("appOut.position=" + this.appOut.position());
                    this.netOut.clear();
                    Debug.out.println("Wrapping: " + this.engine.wrap(this.appOut, this.netOut));
                    this.netOut.flip();
                    Debug.out.println("Wrote " + this.packetSock.write(this.netOut) + " bytes");
                    continue;
                }
                if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    Debug.out.println("######## NEED_UNWRAP ################\n");
                    if (this.netIn.position() == 0) {
                        Debug.out.println("Read " + this.packetSock.read(this.netIn) + " bytes");
                    }
                    this.netIn.flip();
                    Debug.out.println("Unwrapping: " + this.engine.unwrap(this.netIn, this.appIn));
                    this.netIn.compact();
                    Debug.out.println("netIn.position(): " + this.netIn.position());
                    continue;
                }
                if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                Debug.out.println("######## NEED_TASK ################\n");
                while ((runnable = this.engine.getDelegatedTask()) != null) {
                    runnable.run();
                }
            }
        }
        catch (SSLException e) {
            System.err.println(LocaleStrings.GetString("8_4_PACKETMAST") + e.getMessage());
        }
        this.debugOut("Handshaking is complete!");
    }

    public void close() throws IOException {
        this.packetSock.close();
        this.packetSel.close();
    }

    public void wakeup() {
        this.wakeup = true;
        this.packetSel.wakeup();
    }

    public void sendPacket(RedirPacket packet) throws IOException, EncryptionException {
        this.appOut.clear();
        this.netOut.clear();
        packet.writePacket(this.appOut);
        this.appOut.flip();
        if (this.engine != null) {
            while (this.appOut.hasRemaining()) {
                this.netOut.clear();
                SSLEngineResult result = this.engine.wrap(this.appOut, this.netOut);
                this.netOut.flip();
                while (this.netOut.hasRemaining() && this.packetSock.write(this.netOut) != -1) {
                }
            }
        } else {
            while (this.netOut.hasRemaining() && this.packetSock.write(this.netOut) != -1) {
            }
        }
    }

    public RedirPacket receivePacket(boolean clearBuffer) throws IOException, RedirectionException {
        int rc = 0;
        RedirPacket packet = null;
        if (this.appIn.position() != 0) {
            this.appIn.flip();
            packet = this.protocol.getPacket(this.appIn);
            if (packet == null) {
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
            } else {
                this.debugOut("Got a packet!");
            }
        }
        while (packet == null) {
            if (!this.packetSock.isOpen()) {
                throw new IOException(LocaleStrings.GetString("8_5_PACKETMAST"));
            }
            int selRet = this.packetSel.select(60000L);
            if (this.wakeup) {
                this.wakeup = false;
                return null;
            }
            if (selRet > 0) {
                Iterator<SelectionKey> it = this.packetSel.selectedKeys().iterator();
                SelectionKey sel = it.next();
                it.remove();
                rc = this.packetSock.read(this.netIn);
                if (rc < 0) {
                    throw new IOException(LocaleStrings.GetString("8_5_PACKETMAST"));
                }
            } else {
                if (this.isConnectionAlive()) continue;
                this.close();
                throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
            }
            this.debugOut("Read " + this.netIn.position() + " bytes");
            if (this.engine != null) {
                this.netIn.flip();
                SSLEngineResult result = this.engine.unwrap(this.netIn, this.appIn);
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    this.netIn.compact();
                } else {
                    this.netIn.position(this.netIn.limit());
                    this.netIn.limit(this.netIn.capacity());
                }
            }
            this.appIn.flip();
            packet = this.protocol.getPacket(this.appIn);
            if (packet == null) {
                this.debugOut("Can't build a packet from input data");
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
                continue;
            }
            this.debugOut("Got a packet!");
        }
        if (clearBuffer) {
            this.appIn.compact();
        }
        return packet;
    }

    public RedirPacket receivePacket(boolean clearBuffer, boolean newstyle) throws IOException, RedirectionException {
        RedirPacket packet = null;
        this.netIn.limit(32);
        this.netIn.position(0);
        int bytes_to_read = 32;
        int bytes_read = 0;
        while (bytes_read < bytes_to_read) {
            int selRet = this.packetSel.select(60000L);
            if (this.wakeup) {
                this.wakeup = false;
                this.debugOut("(Header ) wakeup is true ");
                return null;
            }
            if (selRet > 0) {
                Iterator<SelectionKey> it = this.packetSel.selectedKeys().iterator();
                SelectionKey sel = it.next();
                it.remove();
                int rc = this.packetSock.read(this.netIn);
                this.debugOut("Read " + rc + " bytes");
                if (rc <= 0) continue;
                bytes_read += rc;
                continue;
            }
            if (this.isConnectionAlive()) continue;
            this.close();
            throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
        }
        this.netIn.position(0);
        int data_size = this.protocol.getDataLen(this.appIn);
        if (data_size < 0) {
            this.debugOut("Data size is less than zero");
            return null;
        }
        if (data_size > 0) {
            this.netIn.limit(32 + data_size);
            this.netIn.position(32);
            bytes_to_read = data_size;
            bytes_read = 0;
            while (bytes_read < bytes_to_read) {
                int selRet = this.packetSel.select(60000L);
                if (this.wakeup) {
                    this.wakeup = false;
                    this.debugOut("(Data) Wakeup is true");
                    return null;
                }
                if (selRet > 0) {
                    Iterator<SelectionKey> it = this.packetSel.selectedKeys().iterator();
                    SelectionKey sel = it.next();
                    it.remove();
                    int rc = this.packetSock.read(this.netIn);
                    this.debugOut("Read " + rc + " bytes");
                    if (rc <= 0) continue;
                    bytes_read += rc;
                    continue;
                }
                if (this.isConnectionAlive()) continue;
                this.close();
                throw new RedirectionException(LocaleStrings.GetString("8_6_PACKETMAST"));
            }
        }
        this.netIn.flip();
        if (this.engine != null) {
            SSLEngineResult result = this.engine.unwrap(this.netIn, this.appIn);
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                this.appIn.flip();
            }
            this.netIn.compact();
        }
        if ((packet = this.protocol.getPacket(this.appIn)) == null) {
            this.debugOut("Can't build a packet from input data");
            return null;
        }
        this.debugOut("Got a packet!");
        if (clearBuffer) {
            this.appIn.compact();
        }
        return packet;
    }

    public RedirPacket receivePacket() throws IOException, RedirectionException {
        return this.receivePacket(true);
    }

    public void clearBuffer() {
        this.appIn.compact();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive() {
        boolean connectionAlive = true;
        AbstractInterruptibleChannel testSock = null;
        try {
            testSock = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        }
        catch (IOException e) {
            connectionAlive = false;
        }
        finally {
            try {
                if (testSock != null) {
                    testSock.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error closing test socket: " + e.getMessage());
            }
        }
        return connectionAlive;
    }

    private void debugOut(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }
}

