/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.embed.EmbeddedSceneDSInterface;
import com.sun.javafx.embed.EmbeddedSceneDTInterface;
import com.sun.javafx.embed.EmbeddedSceneInterface;
import com.sun.javafx.embed.HostDragStartListener;
import com.sun.javafx.tk.Toolkit;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javafx.embed.swing.DataFlavorUtils;
import javafx.embed.swing.SwingDragSource;
import javafx.scene.input.TransferMode;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

final class SwingDnD {
    private final Transferable dndTransferable = new DnDTransferable();
    private final DragSource dragSource;
    private final DragSourceListener dragSourceListener;
    private SwingDragSource swingDragSource;
    private EmbeddedSceneDTInterface fxDropTarget;
    private EmbeddedSceneDSInterface fxDragSource;
    private MouseEvent me;

    SwingDnD(final JComponent comp, final EmbeddedSceneInterface embeddedScene) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                SwingDnD.this.storeMouseEvent(me);
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                SwingDnD.this.storeMouseEvent(me);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                SwingDnD.this.storeMouseEvent(me);
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                SwingDnD.this.storeMouseEvent(me);
            }
        });
        this.dragSource = new DragSource();
        this.dragSourceListener = new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                assert (SwingDnD.this.fxDragSource != null);
                try {
                    SwingDnD.this.fxDragSource.dragDropEnd(SwingDnD.dropActionToTransferMode(dsde.getDropAction()));
                }
                finally {
                    SwingDnD.this.fxDragSource = null;
                }
            }
        };
        DropTargetAdapter dtl = new DropTargetAdapter(){
            private TransferMode lastTransferMode;

            @Override
            public void dragEnter(DropTargetDragEvent e) {
                if (SwingDnD.this.swingDragSource != null || SwingDnD.this.fxDropTarget != null) {
                    return;
                }
                assert (SwingDnD.this.swingDragSource == null);
                SwingDnD.this.swingDragSource = new SwingDragSource();
                SwingDnD.this.swingDragSource.updateContents(e, false);
                assert (SwingDnD.this.fxDropTarget == null);
                SwingDnD.this.fxDropTarget = embeddedScene.createDropTarget();
                Point orig = e.getLocation();
                Point screen = new Point(orig);
                SwingUtilities.convertPointToScreen(screen, comp);
                this.lastTransferMode = SwingDnD.this.fxDropTarget.handleDragEnter(orig.x, orig.y, screen.x, screen.y, SwingDnD.dropActionToTransferMode(e.getDropAction()), SwingDnD.this.swingDragSource);
                SwingDnD.this.applyDragResult(this.lastTransferMode, e);
            }

            @Override
            public void dragExit(DropTargetEvent e) {
                assert (SwingDnD.this.swingDragSource != null);
                assert (SwingDnD.this.fxDropTarget != null);
                try {
                    SwingDnD.this.fxDropTarget.handleDragLeave();
                }
                finally {
                    SwingDnD.this.endDnD();
                    this.lastTransferMode = null;
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent e) {
                assert (SwingDnD.this.swingDragSource != null);
                SwingDnD.this.swingDragSource.updateContents(e, false);
                assert (SwingDnD.this.fxDropTarget != null);
                Point orig = e.getLocation();
                Point screen = new Point(orig);
                SwingUtilities.convertPointToScreen(screen, comp);
                this.lastTransferMode = SwingDnD.this.fxDropTarget.handleDragOver(orig.x, orig.y, screen.x, screen.y, SwingDnD.dropActionToTransferMode(e.getDropAction()));
                SwingDnD.this.applyDragResult(this.lastTransferMode, e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void drop(DropTargetDropEvent e) {
                assert (SwingDnD.this.swingDragSource != null);
                SwingDnD.this.applyDropResult(this.lastTransferMode, e);
                SwingDnD.this.swingDragSource.updateContents(e, true);
                Point orig = e.getLocation();
                Point screen = new Point(orig);
                SwingUtilities.convertPointToScreen(screen, comp);
                assert (SwingDnD.this.fxDropTarget != null);
                try {
                    this.lastTransferMode = SwingDnD.this.fxDropTarget.handleDragDrop(orig.x, orig.y, screen.x, screen.y, SwingDnD.dropActionToTransferMode(e.getDropAction()));
                    try {
                        SwingDnD.this.applyDropResult(this.lastTransferMode, e);
                    }
                    catch (InvalidDnDOperationException invalidDnDOperationException) {
                        // empty catch block
                    }
                    e.dropComplete(this.lastTransferMode != null);
                }
                catch (Throwable throwable) {
                    e.dropComplete(this.lastTransferMode != null);
                    SwingDnD.this.endDnD();
                    this.lastTransferMode = null;
                    throw throwable;
                }
                SwingDnD.this.endDnD();
                this.lastTransferMode = null;
            }
        };
        comp.setDropTarget(new DropTarget(comp, 0x40000003, dtl));
    }

    void addNotify() {
        this.dragSource.addDragSourceListener(this.dragSourceListener);
    }

    void removeNotify() {
        this.dragSource.removeDragSourceListener(this.dragSourceListener);
    }

    HostDragStartListener getDragStartListener() {
        return (dragSource, dragAction) -> {
            assert (Toolkit.getToolkit().isFxUserThread());
            assert (dragSource != null);
            SwingUtilities.invokeLater(() -> {
                assert (this.fxDragSource == null);
                assert (this.swingDragSource == null);
                assert (this.fxDropTarget == null);
                this.fxDragSource = dragSource;
                this.startDrag(this.me, this.dndTransferable, dragSource.getSupportedActions(), dragAction);
            });
        };
    }

    private void startDrag(final MouseEvent e, Transferable t, final Set<TransferMode> sa, TransferMode dragAction) {
        assert (sa.contains((Object)dragAction));
        Point pt = new Point(e.getX(), e.getY());
        int action = SwingDnD.transferModeToDropAction(dragAction);
        final class StubDragGestureRecognizer
        extends DragGestureRecognizer {
            StubDragGestureRecognizer(DragSource ds) {
                super(ds, mouseEvent.getComponent());
                this.setSourceActions(SwingDnD.transferModesToDropActions(sa));
                this.appendEvent(e);
            }

            @Override
            protected void registerListeners() {
            }

            @Override
            protected void unregisterListeners() {
            }
        }
        StubDragGestureRecognizer dgs = new StubDragGestureRecognizer(this.dragSource);
        List<InputEvent> events = Arrays.asList(dgs.getTriggerEvent());
        DragGestureEvent dse = new DragGestureEvent(dgs, action, pt, events);
        dse.startDrag(null, t);
    }

    private void endDnD() {
        assert (this.swingDragSource != null);
        assert (this.fxDropTarget != null);
        this.fxDropTarget = null;
        this.swingDragSource = null;
    }

    private void storeMouseEvent(MouseEvent me) {
        this.me = me;
    }

    private void applyDragResult(TransferMode dragResult, DropTargetDragEvent e) {
        if (dragResult == null) {
            e.rejectDrag();
        } else {
            e.acceptDrag(SwingDnD.transferModeToDropAction(dragResult));
        }
    }

    private void applyDropResult(TransferMode dropResult, DropTargetDropEvent e) {
        if (dropResult == null) {
            e.rejectDrop();
        } else {
            e.acceptDrop(SwingDnD.transferModeToDropAction(dropResult));
        }
    }

    static TransferMode dropActionToTransferMode(int dropAction) {
        switch (dropAction) {
            case 1: {
                return TransferMode.COPY;
            }
            case 2: {
                return TransferMode.MOVE;
            }
            case 0x40000000: {
                return TransferMode.LINK;
            }
            case 0: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    static int transferModeToDropAction(TransferMode tm) {
        switch (tm) {
            case COPY: {
                return 1;
            }
            case MOVE: {
                return 2;
            }
            case LINK: {
                return 0x40000000;
            }
        }
        throw new IllegalArgumentException();
    }

    static Set<TransferMode> dropActionsToTransferModes(int dropActions) {
        EnumSet<TransferMode> tms = EnumSet.noneOf(TransferMode.class);
        if ((dropActions & 1) != 0) {
            tms.add(TransferMode.COPY);
        }
        if ((dropActions & 2) != 0) {
            tms.add(TransferMode.MOVE);
        }
        if ((dropActions & 0x40000000) != 0) {
            tms.add(TransferMode.LINK);
        }
        return Collections.unmodifiableSet(tms);
    }

    static int transferModesToDropActions(Set<TransferMode> tms) {
        int dropActions = 0;
        for (TransferMode tm : tms) {
            dropActions |= SwingDnD.transferModeToDropAction(tm);
        }
        return dropActions;
    }

    private final class DnDTransferable
    implements Transferable {
        private DnDTransferable() {
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedEncodingException {
            assert (SwingDnD.this.fxDragSource != null);
            assert (SwingUtilities.isEventDispatchThread());
            String mimeType = DataFlavorUtils.getFxMimeType(flavor);
            return DataFlavorUtils.adjustFxData(flavor, SwingDnD.this.fxDragSource.getData(mimeType));
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            assert (SwingDnD.this.fxDragSource != null);
            assert (SwingUtilities.isEventDispatchThread());
            String[] mimeTypes = SwingDnD.this.fxDragSource.getMimeTypes();
            ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>(mimeTypes.length);
            for (String mime : mimeTypes) {
                DataFlavor flavor = null;
                try {
                    flavor = new DataFlavor(mime);
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                flavors.add(flavor);
            }
            return flavors.toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            assert (SwingDnD.this.fxDragSource != null);
            assert (SwingUtilities.isEventDispatchThread());
            return SwingDnD.this.fxDragSource.isMimeTypeAvailable(DataFlavorUtils.getFxMimeType(flavor));
        }
    }
}

