/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGPerspectiveCamera;
import com.sun.prism.Graphics;
import com.sun.prism.RenderTarget;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.ImagePool;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.scenario.effect.impl.prism.PrRenderInfo;
import com.sun.scenario.effect.impl.prism.PrTexture;

public class PrEffectHelper {
    public static void render(Effect effect, Graphics g, float x, float y, Effect defaultInput) {
        boolean valid;
        PrFilterContext fctx;
        BaseTransform rendertx;
        BaseTransform transform;
        Rectangle rclip = PrEffectHelper.getGraphicsClipNoClone(g);
        BaseTransform origtx = g.getTransformNoClone().copy();
        if (origtx.is2D()) {
            if (x != 0.0f || y != 0.0f || !origtx.isIdentity()) {
                transform = new Affine2D(origtx);
                transform.translate(x, y);
            } else {
                transform = BaseTransform.IDENTITY_TRANSFORM;
            }
            g.setTransform(null);
            rendertx = null;
        } else {
            BaseTransform inv;
            double scaley;
            double scalex = Math.hypot(origtx.getMxx(), origtx.getMyx());
            double scale = Math.max(scalex, scaley = Math.hypot(origtx.getMxy(), origtx.getMyy()));
            if (scale <= 1.0) {
                transform = BaseTransform.IDENTITY_TRANSFORM;
                rendertx = origtx;
            } else {
                transform = BaseTransform.getScaleInstance(scale, scale);
                rendertx = new Affine3D(origtx);
                scale = 1.0 / scale;
                ((Affine3D)rendertx).scale(scale, scale);
            }
            NGCamera cam = g.getCameraNoClone();
            try {
                inv = rendertx.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                return;
            }
            PickRay ray = new PickRay();
            Vec3d tmpvec = new Vec3d();
            float x1 = (float)rclip.x + 0.5f;
            float y1 = (float)rclip.y + 0.5f;
            float x2 = (float)(rclip.x + rclip.width) - 0.5f;
            float y2 = (float)(rclip.y + rclip.height) - 0.5f;
            double rtw = g.getRenderTarget().getContentWidth();
            double rth = g.getRenderTarget().getContentHeight();
            Point2D cul = PrEffectHelper.project(x1, y1, rtw, rth, cam, inv, ray, tmpvec, null);
            Point2D cur = PrEffectHelper.project(x2, y1, rtw, rth, cam, inv, ray, tmpvec, null);
            Point2D cll = PrEffectHelper.project(x1, y2, rtw, rth, cam, inv, ray, tmpvec, null);
            Point2D clr = PrEffectHelper.project(x2, y2, rtw, rth, cam, inv, ray, tmpvec, null);
            rclip = PrEffectHelper.clipbounds(cul, cur, cll, clr);
        }
        Screen screen = g.getAssociatedScreen();
        if (screen == null) {
            ResourceFactory factory = g.getResourceFactory();
            fctx = PrFilterContext.getPrinterContext(factory);
        } else {
            fctx = PrFilterContext.getInstance(screen);
        }
        PrRenderInfo prinfo = rendertx != null ? null : (g.isDepthBuffer() && g.isDepthTest() ? null : new PrRenderInfo(g));
        ++ImagePool.numEffects;
        do {
            ImageData res;
            if ((res = effect.filter(fctx, transform, rclip, prinfo, defaultInput)) == null) {
                return;
            }
            valid = res.validate(fctx);
            if (valid) {
                Rectangle r = res.getUntransformedBounds();
                Object tex = ((PrTexture)((Object)res.getUntransformedImage())).getTextureObject();
                g.setTransform(rendertx);
                g.transform(res.getTransform());
                g.drawTexture((Texture)tex, r.x, r.y, r.width, r.height);
            }
            res.unref();
        } while (!valid);
        g.setTransform(origtx);
    }

    static Point2D project(float x, float y, double vw, double vh, NGCamera cam, BaseTransform inv, PickRay tmpray, Vec3d tmpvec, Point2D ret) {
        double xscale = cam.getViewWidth() / vw;
        double yscale = cam.getViewHeight() / vh;
        x = (float)((double)x * xscale);
        y = (float)((double)y * yscale);
        tmpray = cam.computePickRay(x, y, tmpray);
        PrEffectHelper.unscale(tmpray.getOriginNoClone(), xscale, yscale);
        PrEffectHelper.unscale(tmpray.getDirectionNoClone(), xscale, yscale);
        return tmpray.projectToZeroPlane(inv, cam instanceof NGPerspectiveCamera, tmpvec, ret);
    }

    private static void unscale(Vec3d v, double sx, double sy) {
        v.x /= sx;
        v.y /= sy;
    }

    static Rectangle clipbounds(Point2D cul, Point2D cur, Point2D cll, Point2D clr) {
        if (cul != null && cur != null && cll != null && clr != null) {
            double y2;
            double y1;
            double x2;
            double x1;
            if (cul.x < cur.x) {
                x1 = cul.x;
                x2 = cur.x;
            } else {
                x1 = cur.x;
                x2 = cul.x;
            }
            if (cul.y < cur.y) {
                y1 = cul.y;
                y2 = cur.y;
            } else {
                y1 = cur.y;
                y2 = cul.y;
            }
            if (cll.x < clr.x) {
                x1 = Math.min(x1, (double)cll.x);
                x2 = Math.max(x2, (double)clr.x);
            } else {
                x1 = Math.min(x1, (double)clr.x);
                x2 = Math.max(x2, (double)cll.x);
            }
            if (cll.y < clr.y) {
                y1 = Math.min(y1, (double)cll.y);
                y2 = Math.max(y2, (double)clr.y);
            } else {
                y1 = Math.min(y1, (double)clr.y);
                y2 = Math.max(y2, (double)cll.y);
            }
            x1 = Math.floor(x1 - 0.5);
            y1 = Math.floor(y1 - 0.5);
            x2 = Math.ceil(x2 + 0.5) - x1;
            y2 = Math.ceil(y2 + 0.5) - y1;
            int x = (int)x1;
            int y = (int)y1;
            int w = (int)x2;
            int h = (int)y2;
            if ((double)x == x1 && (double)y == y1 && (double)w == x2 && (double)h == y2) {
                return new Rectangle(x, y, w, h);
            }
        }
        return null;
    }

    public static Rectangle getGraphicsClipNoClone(Graphics g) {
        Rectangle rclip = g.getClipRectNoClone();
        if (rclip == null) {
            RenderTarget rt = g.getRenderTarget();
            rclip = new Rectangle(rt.getContentWidth(), rt.getContentHeight());
        }
        return rclip;
    }

    public static void renderImageData(Graphics gdst, ImageData srcData, Rectangle dstBounds) {
        int w = dstBounds.width;
        int h = dstBounds.height;
        PrDrawable src = (PrDrawable)srcData.getUntransformedImage();
        BaseTransform srcTx = srcData.getTransform();
        Rectangle srcBounds = srcData.getUntransformedBounds();
        float dx1 = 0.0f;
        float dy1 = 0.0f;
        float dx2 = dx1 + (float)w;
        float dy2 = dy1 + (float)h;
        if (srcTx.isTranslateOrIdentity()) {
            float tx = (float)srcTx.getMxt();
            float ty = (float)srcTx.getMyt();
            float sx1 = (float)dstBounds.x - ((float)srcBounds.x + tx);
            float sy1 = (float)dstBounds.y - ((float)srcBounds.y + ty);
            float sx2 = sx1 + (float)w;
            float sy2 = sy1 + (float)h;
            gdst.drawTexture((Texture)src.getTextureObject(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
        } else {
            float[] srcRect = new float[8];
            int srcCoords = EffectPeer.getTextureCoordinates(srcRect, srcBounds.x, srcBounds.y, src.getPhysicalWidth(), src.getPhysicalHeight(), dstBounds, srcTx);
            if (srcCoords < 8) {
                gdst.drawTextureRaw((Texture)src.getTextureObject(), dx1, dy1, dx2, dy2, srcRect[0], srcRect[1], srcRect[2], srcRect[3]);
            } else {
                gdst.drawMappedTextureRaw((Texture)src.getTextureObject(), dx1, dy1, dx2, dy2, srcRect[0], srcRect[1], srcRect[4], srcRect[5], srcRect[6], srcRect[7], srcRect[2], srcRect[3]);
            }
        }
    }
}

