/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import nn.pp.sara.MousePanel;

class MouseVisual
extends Canvas {
    MousePanel panel;
    int buttonMask = 0;
    int wheel = 0;
    int bw = 15;
    int bh = 25;
    int mh = 80;
    int r = 20;
    int wl = 10;
    int ml = 10;
    int mt = 5;
    int wh = 5;
    int ww = 6;
    Color cm = Color.BLACK;
    Color cbd = Color.RED;
    Color cwa = Color.GREEN;
    Color cwi = Color.BLACK;
    Graphics bufferGraphics;
    Image offscreen;

    MouseVisual(MousePanel panel) {
        this.panel = panel;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(3 * this.bw + 2 * this.wl, this.mh + 2 * this.mt + this.wl);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    private void initDoubleBuffer() {
        Dimension dim = this.getMinimumSize();
        this.offscreen = this.createImage(dim.width, dim.height);
        this.bufferGraphics = this.offscreen.getGraphics();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.bufferGraphics == null) {
            this.initDoubleBuffer();
        }
        this.paintMouse(this.bufferGraphics);
        g.drawImage(this.offscreen, 0, 0, this);
    }

    private void paintMouse(Graphics g) {
        int i;
        int b1x = this.ml;
        int b2x = b1x + this.bw;
        int b3x = b2x + this.bw;
        int b3x2 = b3x + this.bw;
        int by1 = this.mt + this.wl;
        int by2 = by1 + this.bh;
        int by3 = this.mh + by1 - this.r / 2;
        g.setColor(this.cm);
        g.drawLine(b1x, by1, b3x2, by1);
        g.drawLine(b1x, by2, b3x2, by2);
        g.drawLine(b1x, by1, b1x, by2);
        g.drawLine(b2x, by1, b2x, by2);
        g.drawLine(b3x, by1, b3x, by2);
        g.drawLine(b3x2, by1, b3x2, by2);
        g.drawLine(b1x, by2, b1x, by3);
        g.drawLine(b3x2, by2, b3x2, by3);
        g.drawArc(b1x, by3 - this.r / 2, b3x2 - b1x, this.r, 180, 180);
        g.drawLine((b1x + b3x2) / 2, this.mt, (b1x + b3x2) / 2, by1);
        int[] xf = new int[]{b1x + 1, b2x + 1, b3x + 1};
        int yf = by1 + 1;
        int wf = this.bw - 1;
        int hf = this.bh - 1;
        for (i = 0; i < 3; ++i) {
            if ((this.buttonMask & 1 << i) != 0) {
                g.setColor(this.cbd);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(xf[i], yf, wf, hf);
        }
        Color[] cw = new Color[2];
        if (this.wheel < 0) {
            cw[0] = this.cwa;
            cw[1] = this.cwi;
        } else if (this.wheel > 0) {
            cw[0] = this.cwi;
            cw[1] = this.cwa;
        } else {
            cw[0] = this.cwi;
            cw[1] = this.cwi;
        }
        int _x = (b1x + b3x2) / 2;
        int _y1 = by1 + 2;
        int _y2 = by2 - 2;
        int[][] wx = new int[][]{{_x, _x - this.ww / 2, _x + this.ww / 2}, {_x - this.ww / 2, _x, _x + this.ww / 2}};
        int[][] wy = new int[][]{{_y1, _y1 + this.wh, _y1 + this.wh}, {_y2 - this.wh, _y2, _y2 - this.wh}};
        for (i = 0; i < 2; ++i) {
            g.setColor(cw[i]);
            g.drawPolygon(wx[i], wy[i], 3);
            g.fillPolygon(wx[i], wy[i], 3);
        }
    }

    void processButtons(int mask) {
        this.buttonMask = mask;
        this.repaint();
    }

    void processWheel(int wheel) {
        this.wheel = wheel;
        this.repaint();
    }
}

