/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.sara;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Label;
import java.awt.Panel;
import nn.pp.rc.FixedLabel;
import nn.pp.rc.SasEvent;
import nn.pp.sara.InfoPanel;

abstract class InfoPanelPart
extends Panel {
    InfoPanel info;
    Label userLabel;
    Label sourceLabel;
    Label timeLabel;
    boolean hasSource;

    InfoPanelPart(InfoPanel info, boolean hasSource) {
        this.info = info;
        this.hasSource = hasSource;
    }

    void addLayout() {
        this.setLayout(new BorderLayout());
        Label header = new Label(this.getHeader());
        header.setFont(new Font("Helvetica", 1, 12));
        this.add((Component)header, "North");
        if (this.hasSource) {
            Panel sourcePanel = new Panel();
            sourcePanel.setLayout(new BorderLayout());
            if (!this.info.localOnly) {
                this.userLabel = new FixedLabel("xxxxxxxxxxxxxxxxxxxxxxxx");
                sourcePanel.add((Component)this.userLabel, "North");
                this.sourceLabel = new FixedLabel("888.888.888.888");
                sourcePanel.add((Component)this.sourceLabel, "Center");
            }
            this.timeLabel = new FixedLabel("888.888.888.888");
            sourcePanel.add((Component)this.timeLabel, "South");
            this.add((Component)sourcePanel, "South");
        }
        this.addPartLayout();
    }

    void handleSasEvent(SasEvent evt) {
        if (this.userLabel != null) {
            this.userLabel.setText(this.info.getEventUser(evt));
        }
        if (this.sourceLabel != null) {
            this.sourceLabel.setText(this.info.getEventIp(evt));
        }
        if (this.timeLabel != null) {
            this.timeLabel.setText(this.info.getEventTime(evt, false));
        }
        this.handlePartSasEvent(evt);
    }

    protected void setUser(String user) {
        if (this.userLabel != null) {
            this.userLabel.setText(user);
        }
    }

    protected void setIp(String ip) {
        if (this.sourceLabel != null) {
            this.sourceLabel.setText(ip);
        }
    }

    protected void clearSource() {
        if (this.userLabel != null) {
            this.userLabel.setText("");
        }
        if (this.sourceLabel != null) {
            this.sourceLabel.setText("");
        }
        if (this.timeLabel != null) {
            this.timeLabel.setText("");
        }
    }

    abstract String getHeader();

    abstract void addPartLayout();

    abstract void handlePartSasEvent(SasEvent var1);
}

