/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc.test;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import nn.pp.rc.test.FixedGlassPane;

public class SwingGlassExample
extends JFrame {
    FixedGlassPane glass;
    JProgressBar waiter = new JProgressBar(0, 100);
    Timer timer;

    public SwingGlassExample() {
        super("GlassPane Demo");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        JPanel mainPane = new JPanel();
        mainPane.setBackground(Color.white);
        JButton redB = new JButton("Red");
        JButton blueB = new JButton("Blue");
        JButton greenB = new JButton("Green");
        mainPane.add(redB);
        mainPane.add(greenB);
        mainPane.add(blueB);
        mainPane.add(new JLabel(new ImageIcon("oreilly.gif")));
        PopupDebugger pd = new PopupDebugger(this);
        redB.addActionListener(pd);
        greenB.addActionListener(pd);
        blueB.addActionListener(pd);
        JButton startB = new JButton("Start the big operation!");
        startB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent A) {
                SwingGlassExample.this.glass.setNeedToRedispatch(false);
                SwingGlassExample.this.glass.setVisible(true);
                SwingGlassExample.this.startTimer();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.add((Component)mainPane, "Center");
        contentPane.add((Component)startB, "South");
        JPanel controlPane = new JPanel(new GridLayout(2, 1));
        controlPane.setOpaque(false);
        controlPane.add(new JLabel("Please wait..."));
        controlPane.add(this.waiter);
        this.glass = new FixedGlassPane(this.getJMenuBar(), this.getContentPane());
        this.glass.setLayout(new GridLayout(0, 1));
        this.glass.setOpaque(false);
        this.glass.add(new JLabel());
        this.glass.add(new JLabel());
        this.glass.add(controlPane);
        this.glass.add(new JLabel());
        this.glass.add(new JLabel());
        this.setGlassPane(this.glass);
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1000, new ActionListener(){
                int progress = 0;

                @Override
                public void actionPerformed(ActionEvent A) {
                    this.progress += 10;
                    SwingGlassExample.this.waiter.setValue(this.progress);
                    if (this.progress >= 100) {
                        this.progress = 0;
                        SwingGlassExample.this.timer.stop();
                        SwingGlassExample.this.glass.setVisible(false);
                        SwingGlassExample.this.glass.setNeedToRedispatch(true);
                        SwingGlassExample.this.waiter.setValue(0);
                    }
                }
            });
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
    }

    public static void main(String[] args) {
        SwingGlassExample ge = new SwingGlassExample();
        ge.setVisible(true);
    }

    public class PopupDebugger
    implements ActionListener {
        private JFrame parent;

        public PopupDebugger(JFrame f) {
            this.parent = f;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JOptionPane.showMessageDialog(this.parent, ae.getActionCommand());
        }
    }
}

