/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import nn.pp.rc.ParameterReader;
import nn.pp.rc.RemoteConsoleLoader;
import nn.pp.rc.StateMessageInterface;
import nn.pp.rc.T;

public class RemoteConsoleApplet
extends Applet
implements StateMessageInterface,
ParameterReader {
    private RemoteConsoleLoader loader;
    private Image logo = null;
    private Image logo_off = null;
    private URL logourl = null;
    boolean inFrame;
    private boolean bConState = false;
    private Color bgcolor;
    private String stateMsg = T._("Remote Console connecting...");
    private String stateMsgOn = T._("Remote Console connected!");
    private String stateMsgOff = T._("Remote Console disconnected!");
    private static final int INVALID_X_POS = 9999;
    private int stateMsgXpos = 9999;

    public RemoteConsoleApplet() {
        this.enableEvents(16L);
        this.setLayout(new BorderLayout());
    }

    @Override
    public void init() {
        try {
            this.runRemoteConsole();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runRemoteConsole() throws Exception {
        String s;
        String lang = this.readParameter("LANGUAGE", false);
        if (lang != null) {
            T.loadCatalog(lang);
            this.stateMsg = T._("Remote Console connecting...");
            this.stateMsgOn = T._("Remote Console connected!");
            this.stateMsgOff = T._("Remote Console disconnected!");
        }
        this.inFrame = (s = this.readParameter("InFrame", false)) != null && s.equals("yes");
        this.loader = new RemoteConsoleLoader(this, this);
        this.add((Component)this.loader, "Center");
        this.loader.init(this.inFrame, this.getCodeBase(), this.getAppletContext(), true);
        if (this.inFrame) {
            String url = this.readParameter("OnCloseURL", false);
            if (url != null) {
                this.loader.setOnCloseURL(url, this.readParameter("OnCloseURLTarget", false));
            }
            try {
                String file2;
                String cs = this.readParameter("bgcolor", false).substring(1);
                this.bgcolor = new Color(Integer.valueOf(cs, 16));
                try {
                    file2 = this.readParameter("logo", false);
                    if (file2 != null && file2.length() > 0) {
                        URL logoloc = new URL(this.getCodeBase(), file2);
                        System.out.println(logoloc);
                        this.logo = this.getImage(logoloc);
                    }
                }
                catch (MalformedURLException file2) {
                    // empty catch block
                }
                try {
                    file2 = this.readParameter("logo_off", false);
                    if (file2 != null && file2.length() > 0) {
                        URL logoloc_off = new URL(this.getCodeBase(), file2);
                        System.out.println(logoloc_off);
                        this.logo_off = this.getImage(logoloc_off);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                try {
                    this.logourl = new URL(this.readParameter("logourl", false));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            catch (Exception e) {
                System.out.println("rca: ERROR: " + e);
            }
        }
    }

    @Override
    public void start() {
        System.out.println("rca: start...");
    }

    @Override
    public void stop() {
        System.out.println("rca: stop...");
    }

    @Override
    public void destroy() {
        System.out.println("rca: destroy...");
        if (this.loader != null) {
            this.loader.destroy();
        }
        this.loader = null;
        if (this.logo != null) {
            this.logo.flush();
        }
        if (this.logo_off != null) {
            this.logo.flush();
        }
    }

    @Override
    public void setStateMessage(boolean conState) {
        this.bConState = conState;
        this.stateMsgXpos = 9999;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.inFrame) {
            Image logo_show = this.bConState ? this.logo : this.logo_off;
            Dimension d = this.getSize();
            g.setColor(this.bgcolor);
            g.fillRect(0, 0, d.width, d.height);
            if (logo_show != null) {
                int iw = logo_show.getWidth(this);
                int xpos = iw > 0 ? (d.width - iw) / 2 : 0;
                g.drawImage(logo_show, xpos, 0, this.bgcolor, this);
            }
            g.setColor(Color.black);
            if (this.loader.displayStateMsg()) {
                String msg;
                String string = msg = this.bConState ? this.stateMsgOn : this.stateMsgOff;
                if (9999 == this.stateMsgXpos) {
                    FontMetrics fm = g.getFontMetrics();
                    this.stateMsgXpos = (d.width - fm.stringWidth(msg)) / 2;
                }
                g.drawString(msg, this.stateMsgXpos, this.loader.adjustStateMsgPos(d.height));
            }
        } else {
            super.paint(g);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 500: {
                if (this.logourl == null) break;
                this.getAppletContext().showDocument(this.logourl, "_top");
                break;
            }
            case 505: {
                if (this.logourl == null) break;
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
            case 504: {
                if (this.logourl == null) break;
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }

    @Override
    public void parameterError(String s) {
        System.out.println(s);
        this.add(new Label(T._("Fatal Error:") + " " + s));
        Thread.currentThread().stop();
    }

    @Override
    public String readParameter(String name, boolean required) {
        String s = this.getParameter(name);
        if (s == null && required) {
            this.parameterError(MessageFormat.format(T._("Required Applet parameter \"{0}\" not found"), name));
        }
        return s;
    }

    @Override
    public String[] readArrayParameter(String basename) {
        String s;
        int index = 0;
        while (null != (s = this.getParameter(basename + index))) {
            ++index;
        }
        String[] hotkeys = new String[index];
        for (int i = 0; i < index; ++i) {
            hotkeys[i] = s = this.getParameter(basename + i);
        }
        return hotkeys;
    }

    @Override
    public String getRemoteHost() {
        return this.getCodeBase().getHost();
    }
}

