/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nn.pp.rc.FocusHandler;
import nn.pp.rc.HistoryFrame;
import nn.pp.rc.T;

public class Logger
extends JPanel {
    private boolean stdout;
    PrintStream mystream;
    JLabel stateline;
    HistoryFrame details;
    private boolean tiny = false;
    FocusHandler fh;

    public Logger(String text, FocusHandler focusHandler, boolean stdoutOutput) {
        super(new BorderLayout());
        this.fh = focusHandler;
        this.stdout = stdoutOutput;
        this.mystream = new PrintStream(new LoggerStream(), false);
        this.stateline = new JLabel(text);
        this.details = new HistoryFrame(text);
        this.add((Component)this.stateline, "Center");
        this.stateline.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    Logger.this.fh.handleFocus((Component)e.getSource());
                    Logger.this.details.show();
                    Logger.this.details.toFront();
                }
            }
        });
    }

    public PrintStream getPrintStream() {
        return this.mystream;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 0);
    }

    public void close() {
        this.details.close();
    }

    public void setTiny(boolean tiny) {
        if (this.tiny == tiny) {
            return;
        }
        this.tiny = tiny;
        if (tiny) {
            this.remove(this.stateline);
        } else {
            this.add((Component)this.stateline, "Center");
        }
        this.validate();
    }

    public JLabel getStateline() {
        return this.stateline;
    }

    class LoggerStream
    extends OutputStream {
        private boolean nltrunc = false;

        LoggerStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] bb = new byte[]{(byte)b};
            this.write(bb);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String s = new String(b);
            this.update(s);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String s = new String(b, off, len);
            this.update(s);
        }

        private void update(String s) {
            Logger.this.details.append(s);
            String ns = s.replace('\t', ' ');
            if (this.nltrunc) {
                Logger.this.stateline.setText(T._(this.getLastLine(ns)));
            } else {
                Logger.this.stateline.setText(T._(Logger.this.stateline.getText() + this.getLastLine(ns)));
            }
        }

        private String getLastLine(String s) {
            int starti;
            int endi = s.length();
            if (endi == 0) {
                return s;
            }
            if (s.charAt(endi - 1) == '\n') {
                this.nltrunc = true;
                if (--endi == 0) {
                    return "";
                }
            } else {
                this.nltrunc = false;
            }
            return s.substring((starti = s.lastIndexOf(10, endi)) < 0 ? 0 : starti, endi);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

