/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.text.NMPolicyDto;
import com.supermicro.ipmi.text.nm.summary.NMDomain;
import com.supermicro.ipmi.text.nm.summary.NMPolicyTable;
import com.supermicro.ipmi.util.StringUtil;

public class NMPolicyInfo {
    private int globalState = -1;
    private int count = 0;
    private NMDomain entire = new NMDomain(Common.Domain.ENTIRE.getValue());
    private NMDomain cpu = new NMDomain(Common.Domain.CPU.getValue());
    private NMDomain mem = new NMDomain(Common.Domain.MEMORY.getValue());
    private NMDomain hpio = new NMDomain(Common.Domain.HPIO.getValue());
    private IPMINM20Command ipmiCommand;

    public NMPolicyInfo(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
        this.getInfo();
    }

    public void display() {
        if (this.globalState == -1) {
            System.out.println("Node Manager Policy: Not set");
            return;
        }
        NMPolicyTable table = new NMPolicyTable();
        String title = String.format("Node Manager Policy (%d) [%s]", this.count, this.globalState == 1 ? "Enable" : "Disable");
        System.out.println(StringUtil.center(title, "+-----------------------------------------------------------------+".length()));
        if (this.entire.getCount() != 0) {
            table.display(this.entire);
        }
        if (this.cpu.getCount() != 0) {
            table.display(this.cpu);
        }
        if (this.mem.getCount() != 0) {
            table.display(this.mem);
        }
        if (this.hpio.getCount() != 0) {
            table.display(this.hpio);
        }
        System.out.println("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    private void getInfo() {
        this.scan(this.entire);
        this.scan(this.cpu);
        this.scan(this.mem);
        this.scan(this.hpio);
        this.count = this.entire.getCount() + this.cpu.getCount() + this.mem.getCount() + this.hpio.getCount();
    }

    private void scan(NMDomain dp) {
        IPMINM20Command.NodeManagerPolicy policy = null;
        byte pid = 0;
        byte policyCount = 0;
        block2: while (true) {
            try {
                while (true) {
                    policy = this.ipmiCommand.getNodeManagerPolicy((byte)dp.domainId, pid);
                    NMPolicyDto pd = new NMPolicyDto(policy);
                    dp.addPolicy(pid & 0xFF, pd);
                    this.setGlobalState(pd.isGlobalEnable());
                    policyCount = (byte)(policyCount + 1);
                    if ((pid & 0xFF) == 255) break block2;
                    pid = (byte)(pid + 1);
                }
            }
            catch (IPMIException ex) {
                if ((pid & 0xFF) == 255) break;
                IPMIMessage ipmiMessage = ex.getIPMIMessage();
                if (ipmiMessage.completionCode != -128) break;
                byte nextValidPid = ex.getIPMIMessage().data[3];
                byte numOfPolicy = ex.getIPMIMessage().data[4];
                if (policyCount == numOfPolicy) break;
                pid = nextValidPid;
                continue;
            }
            break;
        }
    }

    private void setGlobalState(boolean enabled) {
        if (this.globalState == -1) {
            this.globalState = enabled ? 1 : 0;
        }
    }
}

