/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIHDDOEMCommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;

public class VRMCompare3746Command
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIHDDOEMCommand ipmiHDDOEMCommand = new IPMIHDDOEMCommand(null);
        ipmiHDDOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 1;
        byte slaveAddr = 72;
        byte[] data = new byte[2];
        boolean isExtend = false;
        boolean isFile1Update = true;
        boolean isFile2Update = true;
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.G(this).println("Please specify the psf file path.");
        } else {
            ipmiHDDOEMCommand.setSensorPollingFlag(false);
            Thread.sleep(1000L);
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            MOut.G(this).println("Open file1 and compare to VRM adress......");
            FileReader frc1 = new FileReader(this.parameters[0]);
            if (frc1 == null) {
                MOut.G(this).println("Open file1 fail.");
                MOut.G(this).println("255 = update/verify failed to complete (hex code 0xff: error 38 cause early exit)");
                this.statusCode = 147;
                ipmiHDDOEMCommand.setSensorPollingFlag(true);
                return;
            }
            BufferedReader brc1 = new BufferedReader(frc1);
            isExtend = false;
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            while (brc1.ready()) {
                String s = brc1.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                byte[] readResult = ipmiI2CPMBusCommand.checkVRMdata(adress);
                value = this.get_data(s);
                if (Arrays.equals(value, readResult)) continue;
                ipmiHDDOEMCommand.setSensorPollingFlag(true);
                isFile1Update = false;
                break;
            }
            frc1.close();
            Thread.sleep(500L);
            slaveAddr = 104;
            ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
            MOut.G(this).println("Open file2 and compare to VRM adress......");
            FileReader frc2 = new FileReader(this.parameters[1]);
            if (frc2 == null) {
                MOut.G(this).println("Open file2 fail.");
                MOut.G(this).println("255 = update/verify failed to complete (hex code 0xff: error 38 cause early exit)");
                this.statusCode = 147;
                ipmiHDDOEMCommand.setSensorPollingFlag(true);
                return;
            }
            BufferedReader brc2 = new BufferedReader(frc2);
            isExtend = false;
            data = new byte[]{0, 32};
            ipmiI2CPMBusCommand.updateVRMdataCommand(data);
            while (brc2.ready()) {
                String s = brc2.readLine();
                byte[] value = new byte[2];
                data = new byte[3];
                int notePosition = s.indexOf("/");
                if (notePosition == 0) continue;
                if (notePosition > 0) {
                    s = s.substring(0, notePosition);
                }
                if (s.substring(1, 2).contains("1")) {
                    isExtend = true;
                    continue;
                }
                if (s.length() < 21) continue;
                byte adress = this.get_Adress(s);
                byte[] readResult = ipmiI2CPMBusCommand.checkVRMdata(adress);
                value = this.get_data(s);
                if (Arrays.equals(value, readResult)) continue;
                ipmiHDDOEMCommand.setSensorPollingFlag(true);
                isFile2Update = false;
                break;
            }
            frc2.close();
            Thread.sleep(500L);
            ipmiHDDOEMCommand.setSensorPollingFlag(true);
            Thread.sleep(500L);
            if (!isFile1Update && !isFile2Update) {
                MOut.G(this).println("48=verify mismatch on both images (optional,hex code 0x30: 'or' of image 1 and image 2 failure)");
            } else if (!isFile1Update) {
                MOut.G(this).println("16=verify mismatch on image 1 (hex code 0x10)");
            } else if (!isFile2Update) {
                MOut.G(this).println("32=verify mismatch on image 2 (hex code 0x20)");
            } else {
                MOut.G(this).println("0=verify completed with no mismatches");
            }
        }
    }

    public byte get_Adress(String s) {
        byte adress = (byte)Integer.parseInt(s.substring(2, 4), 16);
        return adress;
    }

    public byte[] get_data(String s) {
        byte[] data = new byte[2];
        String str_value = s.substring(5, 21);
        data[1] = (byte)Integer.parseInt(str_value.substring(0, 8), 2);
        data[0] = (byte)Integer.parseInt(str_value.substring(8, 16), 2);
        return data;
    }
}

