/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class RemoteKeyboardOperationIKVMCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("No keyboard operation file path");
            MOut.G(this).println("");
            MOut.G(this).println(RemoteKeyboardOperationIKVMCommand.help().toString());
            this.statusCode = 147;
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isATENKVMSupported()) {
            this.printUnavailableMessage();
            return;
        }
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config) && SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                isPassSWKey = true;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return;
        }
        this.createSession();
        if (!isPassSWKey && this.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The Node product key needs to be activated for this device");
            this.statusCode = 153;
            return;
        }
        String jarDir = RemoteKeyboardOperationIKVMCommand.getJarPath(this.getClass()) + File.separator;
        File f = new File(jarDir + "ko.jar");
        if (!f.exists()) {
            MOut.G(this).println("Cannot find ko.jar");
            this.statusCode = 149;
            return;
        }
        String params = "";
        if (this.getParameters() != null) {
            for (int i = 0; i < this.getParameters().length; ++i) {
                params = params + " " + this.getParameters()[i];
            }
        }
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean isStunnelSupport = ipmiOEMPortServiceCommand.checkStunnelSupport();
        boolean isIPv6 = false;
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        if (ca.getProperty("bmc_security") == null) {
            ca.setProperty("bmc_security", "on");
        }
        String isUseStunnel = ca.getProperty("bmc_security");
        String ip = this.config.getIp();
        String token = "--token";
        if ("on".equals(isUseStunnel) && isStunnelSupport) {
            String kvmPort = "3520";
            int CAMode = 0;
            int stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
            if (stunnelVer > 1) {
                try {
                    kvmPort = String.valueOf(ipmiOEMPortServiceCommand.getPort((byte)2));
                }
                catch (IPMIException e) {
                    kvmPort = "3520";
                }
            }
            switch (stunnelVer) {
                case 3: {
                    CAMode = 0;
                    break;
                }
                case 5: {
                    CAMode = 1;
                    break;
                }
                case 7: {
                    CAMode = 2;
                    break;
                }
                default: {
                    CAMode = 0;
                }
            }
            MOut.G(this).println("This device support stunnel.");
            StunnelParameters parameters = new StunnelParameters.Builder(ip, kvmPort).command("ko").build();
            try {
                StunnelUtility.configAndStartStunnel(parameters, this.ipmiCMMOEMCommand.getIPMIInterface(), CAMode);
                token = token + RemoteKeyboardOperationIKVMCommand.getT(parameters.getStunnelIP());
                this.startKeyboardOperation(jarDir, parameters.getStunnelIP(), parameters.getSturnnlPort(), this.config.getUserName(), this.config.getPassword(), params, token, parameters.getStunnelFolder());
            }
            catch (Exception e) {
                MOut.G(this).println("Config stunnel or start stunnel fail" + e);
            }
        } else {
            int port = 5900;
            try {
                port = ipmiOEMPortServiceCommand.getPort((byte)2);
            }
            catch (IPMIException e) {
                port = 5900;
            }
            token = token + RemoteKeyboardOperationIKVMCommand.getT(this.config.getIp());
            this.startKeyboardOperation(jarDir, ip, this.config.getUserName(), this.config.getPassword(), params, token, port);
        }
    }

    public void startKeyboardOperation(String jarDir, String ip, String id, String pw, String params, String token) {
        this.startKeyboardOperation(jarDir, ip, id, pw, params, token, 5900);
    }

    public void startKeyboardOperation(String jarDir, String ip, String port, String id, String pw, String params, String token, String stunnleFolder) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --port" + port + " --stunnelFolder-" + stunnleFolder : "./jre/bin/java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --port" + port + " --stunnelFolder-" + stunnleFolder) : "java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --port" + port + " --stunnelFolder-" + stunnleFolder;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            InputStream stdin = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(stdin);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            String OS = StunnelUtility.checkOS();
            while ((line = br.readLine()) != null) {
                if (OS.indexOf("Windows") <= -1) continue;
                MOut.G(this).println(line);
                return;
            }
            p.waitFor();
            this.statusCode = p.exitValue();
            MOut.G(this).println("Done");
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
    }

    public void startKeyboardOperation(String jarDir, String ip, String id, String pw, String params, String token, int port) {
        File jre = new File("jre");
        String execString = jre.isDirectory() ? (System.getProperty("os.name").indexOf("Windows") >= 0 ? ".\\jre\\bin\\java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --kvmport" + port : "./jre/bin/java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --kvmport" + port) : "java -Djava.library.path=. -jar ko.jar " + ip + " " + id + " " + pw + " " + params + " " + token + " --kvmport" + port;
        try {
            Process p = Runtime.getRuntime().exec(execString);
            p.waitFor();
            this.statusCode = p.exitValue();
            MOut.G(this).println("Done");
        }
        catch (IOException ex) {
            MOut.G(this).println(" Failed");
            this.statusCode = 149;
            return;
        }
        catch (Exception e) {
            MOut.G(this).println(" Failed " + e);
            this.statusCode = 149;
            return;
        }
    }

    private static StringBuffer help() {
        StringBuffer sb = new StringBuffer();
        sb.append(" ============================================================================\n");
        sb.append(" |                     Remote Keyboard Operation Help                       |\n");
        sb.append(" ============================================================================\n");
        sb.append(" Keyboard Operation Parameters List\n");
        sb.append(" ----------------------------------\n");
        sb.append(" Alphanumeric Keys : A-Z, a-z, 0-9, Symbols Keys (example: ,./!#%& ... etc)\n");
        sb.append(" Modifier Keys     : [Shift], [Ctrl], [Alt], [Win]\n");
        sb.append(" Navigation Keys   : [Up], [Down], [Left], [Right], [PageUp], [PageDown],\n");
        sb.append("                     [Home], [End]\n");
        sb.append(" Editing Keys      : [Enter], [Backspace], [Insert], [Delete], [Tab], [Space]\n");
        sb.append(" Miscellaneous Keys: [PrtSc], [Pause], [Esc], [F1]-[F12]\n");
        sb.append(" Macro Key example : [Ctrl+Alt+Delete], [Alt+F4], [Ctrl+v] ... etc\n");
        sb.append(" Delay Parameter   : [Delay=?h?m?s], [Delay=?m?s], [Delay=?s]\n");
        sb.append("\n");
        sb.append("\n");
        sb.append(" Keyboard Operation File Sample\n");
        sb.append(" ------------------------------\n");
        sb.append(" [Ctrl+Alt+Delete][Delay=5s]\n");
        sb.append(" password[Enter][Delay=10s]\n");
        sb.append(" cmd[Enter][Delay=1s]\n");
        sb.append(" ipconfig[Enter]\n");
        return sb;
    }

    public void printUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device.");
    }

    public boolean isATENKVMSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isATENGUID(guid) || IPMIMessagingCommand.isATENAspeedGUID(guid) || IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || IPMIMessagingCommand.isATENSuperBladeGUID(guid) || IPMIMessagingCommand.isSAS3_946E90GUID(guid) || IPMIMessagingCommand.isAST2400GUID(guid) || IPMIMessagingCommand.isAST2500GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.is8USuperBladeGUID(guid) || IPMIMessagingCommand.isAST2500HW1GUID(guid) || IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isH12GUID(guid)) {
            result = true;
        }
        return result;
    }

    public static String getT(String ip) {
        byte[] result = null;
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        String dateShortString = f.format(date);
        byte[] key = dateShortString.getBytes();
        byte[] plainText = ip.getBytes();
        try {
            Mac hmacMD5 = Mac.getInstance("HmacMD5");
            SecretKeySpec sks = new SecretKeySpec(key, "HmacMD5");
            hmacMD5.init(sks);
            result = hmacMD5.doFinal(plainText);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return ByteUtility.bytesToHexNoSpace(result);
    }
}

