/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20ResetStatisticsCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        if (this.parameters == null || this.parameters.length < 3) {
            MOut.G(this).println("resetStatistics <mode> <domain ID> <policy ID>");
            MOut.G(this).println("mode:");
            MOut.G(this).println("  0 (00h) \u00a1V reset global statistics including power and inlet temp");
            MOut.G(this).println("  1 (01h) \u00a1V per policy statistics including power and trigger statistics");
            MOut.G(this).println(" 27 (1Bh) \u00a1V global Host Unhandled Requests statistics");
            MOut.G(this).println(" 28 (1Ch) \u00a1V global Host Response Time statistics");
            MOut.G(this).println(" 29 (1Dh) \u00a1V global CPU throttling statistics");
            MOut.G(this).println(" 30 (1Eh) \u00a1V global memory throttling statistics");
            MOut.G(this).println(" 31 (1Fh) \u00a1V global Host Communication Failure statistics");
            MOut.G(this).println("Domain ID:");
            MOut.G(this).println(" 0 \u00a1V Entire platform");
            MOut.G(this).println(" 1 \u00a1V CPU subsystem");
            MOut.G(this).println(" 2 \u00a1V Memory subsystem");
            MOut.G(this).println(" 3 \u00a1V HW Protection (NM3.0)");
            MOut.G(this).println(" 4 \u00a1V High Power I/O subsystem");
            MOut.G(this).println("Policy ID:");
            MOut.G(this).println(" ignored if field Mode is 0h, Set to 0");
            this.statusCode = 0;
            return;
        }
        byte mode = -1;
        try {
            mode = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        byte did = -1;
        try {
            did = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        byte pid = -1;
        try {
            pid = Byte.parseByte(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        try {
            this.ipmiNM20Command.resetNodeManagerStatistics(mode, did, pid);
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

