/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.util.StringTokenizer;

public class IPMIOEMAlertIPCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    @Override
    public boolean preValidate() {
        block7: {
            try {
                if (this.parameters.length == 1) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    break block7;
                }
                if (this.parameters.length == 2) {
                    if (Integer.parseInt(this.parameters[0]) < 1 || Integer.parseInt(this.parameters[0]) > 16) {
                        MOut.G(this).println("Out of range! (1 - 16)");
                        return false;
                    }
                    if (!IPMILanCommand.isIPAddress(this.parameters[1])) {
                        MOut.G(this).println("IP format error!");
                        return false;
                    }
                    break block7;
                }
                MOut.G(this).println("Parameter error!");
                return false;
            }
            catch (Exception ex) {
                MOut.G(this).println("Parameter error!");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters.length == 1) {
            byte[] bytes = ipmiOEMWebSettingCommand.getAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)0);
            String ip = bytes.length > 1 ? String.format("%s.%s.%s.%s", bytes[1] & 0xFF, bytes[2] & 0xFF, bytes[3] & 0xFF, bytes[4] & 0xFF) : "";
            MOut.G(this).println(ip.length() == 0 ? "N/A" : ip);
        } else {
            byte[] ip = new byte[4];
            StringTokenizer st = new StringTokenizer(this.parameters[1], ".");
            for (int i = 0; i < 4; ++i) {
                ip[i] = (byte)Integer.parseInt(st.nextToken());
            }
            ipmiOEMWebSettingCommand.setAlert((byte)(Integer.parseInt(this.parameters[0]) - 1), (byte)3, ip);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }
}

