/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.stunnel.BaseStunnel;
import com.supermicro.ipmi.stunnel.CAModeInterface;
import com.supermicro.ipmi.stunnel.CAModeOne;
import com.supermicro.ipmi.stunnel.CAModeTwo;
import com.supermicro.ipmi.stunnel.StunnelFacotry;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.WindowsStunnel;
import com.supermicro.ipmi.text.MOut;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class StunnelUtility {
    public static final boolean isSingleStunnelInstance = false;
    private static final String KVMJAR = "iKVM.jar";
    private static final String SCJAR = "sc.jar";
    private static final String KOJAR = "ko.jar";
    public static final String KVM = "iKVM";
    public static final String SC = "sc";
    public static final String KO = "ko";

    public static StunnelParameters configAndStartStunnel(StunnelParameters parameters, IPMIInterface IPMIInterface2, int CAMode) throws Exception {
        long endTime;
        String OS = StunnelUtility.checkOS();
        boolean isIPv6 = false;
        try {
            isIPv6 = StunnelUtility.isIPv6(parameters.getBMCIP());
        }
        catch (Exception e1) {
            isIPv6 = false;
        }
        String localIP = "127.0.0.1";
        if (OS.indexOf("Windows") == -1 && (localIP = StunnelUtility.getFirstNonLoopbackAddress(!isIPv6, isIPv6).getHostAddress()) == null) {
            localIP = isIPv6 ? "::1" : "127.0.0.1";
        }
        parameters.setStunnelIP(localIP);
        BaseStunnel stunnel = StunnelFacotry.createStunnel(OS, CAMode);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(IPMIInterface2);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid)) {
            CAMode = StunnelUtility.getStunnelVerOnPowerBoard(IPMIInterface2);
        }
        CAModeInterface caInterface = stunnel.getCaInterface();
        String tempDIR = StunnelUtility.getTmpDir();
        String stunnelDir = caInterface.getStunnelDir();
        parameters.setStunnelFolder(stunnelDir);
        stunnelDir = tempDIR + stunnelDir;
        String localStunnelPort = StunnelUtility.getRandomConnectPort() + "";
        parameters.setSturnnlPort(localStunnelPort);
        if ("49999".equals(localStunnelPort)) {
            MOut.G().println("Can not find an unused port for stunnel");
            return parameters;
        }
        StunnelUtility.multiStunnelFlow(stunnel, IPMIInterface2, parameters, CAMode);
        long startTime = System.currentTimeMillis();
        while (!StunnelUtility.isPortUsed(Integer.parseInt(localStunnelPort)) && ((endTime = System.currentTimeMillis()) - startTime) / 1000L <= 4L) {
            StunnelUtility.startStunnel(stunnelDir, stunnel);
            Thread.sleep(1000L);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void singleStunnelFlow(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters, int CAMode) {
        CAModeInterface caInterface = stunnel.getCaInterface();
        String tempDIR = StunnelUtility.getTmpDir();
        String stunnelDir = tempDIR + caInterface.getStunnelDir();
        StunnelUtility.CopyStunnelConfigToTemp(stunnel, IPMIInterface2);
        FileLock lock = null;
        AbstractInterruptibleChannel channel = null;
        try {
            String lockFilePath = stunnelDir + "lockKey.txt";
            channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
            lock = ((FileChannel)channel).lock();
            Thread.sleep(500L);
            StunnelUtility.removeClosedHostFromConfig(stunnelDir);
            StunnelUtility.addHostTolConfig(parameters, stunnelDir, CAMode, stunnel);
            Thread.sleep(500L);
            StunnelUtility.startStunnel(stunnelDir, stunnel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void multiStunnelFlow(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters, int CAMode) {
        String stunnelDir = parameters.getStunnelFolder();
        stunnelDir = StunnelUtility.getTmpDir() + stunnelDir;
        StunnelUtility.multiStunnelSetup(stunnel, IPMIInterface2, parameters);
        try {
            Thread.sleep(500L);
            StunnelUtility.addHostTolConfig(parameters, stunnelDir, CAMode, stunnel);
            Thread.sleep(500L);
            StunnelUtility.startStunnel(stunnelDir, stunnel);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void multiStunnelSetup(BaseStunnel stunnel, IPMIInterface IPMIInterface2, StunnelParameters parameters) {
        CAModeInterface caInterface = stunnel.getCaInterface();
        String stunnelDir = parameters.getStunnelFolder();
        String[] CASource = caInterface.getCASource();
        int CAMode = caInterface.CAMode;
        String tempDIR = StunnelUtility.getTmpDir();
        stunnelDir = tempDIR + stunnelDir;
        File tempFile = new File(stunnelDir);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        String jarPath = StunnelUtility.getJarPath(StunnelUtility.class) + File.separator;
        FileInputStream inputStream = null;
        String tempFilePath = stunnelDir + "mail.pem";
        tempFile = new File(tempFilePath);
        if (!tempFile.exists()) {
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "mail.pem"));
                StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
            }
            catch (Exception e) {
                MOut.G().println("Can not find mail.pem under SMCIPMITool(IPMIView) directory");
                e.printStackTrace();
            }
        }
        if (CAMode == 1) {
            for (int i = 0; i < CASource.length; ++i) {
                tempFilePath = stunnelDir + CASource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + CASource[i]));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                    continue;
                }
                catch (FileNotFoundException e) {
                    MOut.G().println("Can not find BMCSecurity" + File.separator + CASource[i] + " under SMCIPMITool(IPMIView) directory");
                }
            }
        } else if (CAMode == 2) {
            try {
                String[] originalfileNames = CAModeOne.getCAfileNames();
                String fileName = "";
                for (int i = 0; i < CASource.length; ++i) {
                    IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(IPMIInterface2);
                    byte optionCode = CAModeTwo.optionCode[i];
                    fileName = CASource[i];
                    boolean result = ipmiBMCFileCommand.generalFileDownload(optionCode, fileName, false, false);
                    if (!result) {
                        MOut.G().println("download " + originalfileNames[i] + " fail");
                        continue;
                    }
                    tempFilePath = stunnelDir + fileName;
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists()) continue;
                    File file = new File(jarPath + fileName);
                    Files.move(Paths.get(file.getAbsolutePath(), new String[0]), Paths.get(tempFilePath, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    if (tempFile.exists()) continue;
                    MOut.G().println("Move file " + originalfileNames[i] + " fail");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String[] stunnelSource = stunnel.getNativeSource();
        for (int i = 0; i < stunnelSource.length; ++i) {
            tempFilePath = stunnelDir + stunnelSource[i];
            tempFile = new File(tempFilePath);
            if (tempFile.exists()) continue;
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i]));
                StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                continue;
            }
            catch (Exception e) {
                MOut.G().println("Can not find BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i] + " under SMCIPMITool(IPMIView) directory");
                MOut.G().println("This might cause ikvm can not start due to stunnel fail");
                e.printStackTrace();
            }
        }
    }

    public static void CopyStunnelConfigToTemp(BaseStunnel stunnel) {
        StunnelUtility.CopyStunnelConfigToTemp(stunnel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CopyStunnelConfigToTemp(BaseStunnel stunnel, IPMIInterface IPMIInterface2) {
        String path = StunnelUtility.getTmpDir() + stunnel.getCaInterface().getStunnelDir();
        int CAMode = stunnel.getCaInterface().getCAMode();
        String OS = StunnelUtility.checkOS();
        File tempFile = new File(path);
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        String jarPath = StunnelUtility.getJarPath(StunnelUtility.class) + File.separator;
        FileInputStream inputStream = null;
        String tempLockPath = path + "lockKey.txt";
        File lockFile = new File(tempLockPath);
        if (!lockFile.exists()) {
            try {
                inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "lockKey.txt"));
                StunnelUtility.doCreateTempFile(inputStream, lockFile, tempLockPath);
            }
            catch (Exception e) {
                MOut.G().println("Can not find lockKey.txt under SMCIPMITool(IPMIView) directory");
                e.printStackTrace();
            }
        }
        AbstractInterruptibleChannel channel = null;
        FileLock lock = null;
        try {
            String[] CASource;
            String lockFilePath = path + "lockKey.txt";
            channel = new RandomAccessFile(new File(lockFilePath), "rw").getChannel();
            lock = ((FileChannel)channel).lock();
            String tempFilePath = path + "mail.pem";
            tempFile = new File(tempFilePath);
            if (!tempFile.exists()) {
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + "mail.pem"));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                }
                catch (Exception e) {
                    MOut.G().println("Can not find mail.pem under SMCIPMITool(IPMIView) directory");
                    e.printStackTrace();
                }
            }
            if (CAMode == 1) {
                CASource = stunnel.getCaInterface().getCASource();
                for (int i = 0; i < CASource.length; ++i) {
                    tempFilePath = path + CASource[i];
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists()) continue;
                    try {
                        inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + CASource[i]));
                        StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        MOut.G().println("Can not find BMCSecurity" + File.separator + CASource[i] + " under SMCIPMITool(IPMIView) directory");
                    }
                }
            } else if (CAMode == 2) {
                CASource = stunnel.getCaInterface().getCASource();
                String stunnelDir = stunnel.caInterface.getStunnelDir();
                String[] originalfileNames = CAModeOne.getCAfileNames();
                String fileName = "";
                for (int i = 0; i < CASource.length; ++i) {
                    File file;
                    boolean success;
                    IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(IPMIInterface2);
                    byte optionCode = CAModeTwo.optionCode[i];
                    fileName = CASource[i];
                    boolean result = ipmiBMCFileCommand.generalFileDownload(optionCode, fileName, false, false);
                    if (!result) {
                        MOut.G().println("download " + originalfileNames[i] + " fail");
                        continue;
                    }
                    tempFilePath = path + fileName;
                    tempFile = new File(tempFilePath);
                    if (tempFile.exists() || (success = (file = new File(jarPath + fileName)).renameTo(tempFile))) continue;
                    MOut.G().println("Move " + originalfileNames[i] + " fail");
                }
            }
            boolean neeInstall = false;
            String[] stunnelSource = stunnel.getNativeSource();
            for (int i = 0; i < stunnelSource.length; ++i) {
                tempFilePath = path + stunnelSource[i];
                tempFile = new File(tempFilePath);
                if (tempFile.exists()) continue;
                try {
                    inputStream = new FileInputStream(new File(jarPath + "BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i]));
                    StunnelUtility.doCreateTempFile(inputStream, tempFile, tempFilePath);
                    if (OS.indexOf("Windows") <= -1 || i != 0) continue;
                    neeInstall = true;
                    continue;
                }
                catch (Exception e) {
                    MOut.G().println("Can not find BMCSecurity" + File.separator + stunnel.OSDircetory + File.separator + stunnelSource[i] + " under SMCIPMITool(IPMIView) directory");
                    MOut.G().println("This might cause ikvm can not start via stunnel");
                    e.printStackTrace();
                }
            }
            if (neeInstall) {
                String absolutePath = path + "stunnel.exe -install -quiet";
                File file = new File(absolutePath);
                String cmd = file.toString();
                try {
                    Process p = Runtime.getRuntime().exec(cmd);
                    p.waitFor();
                }
                catch (Exception e) {
                    MOut.G().println("stunnel install failure");
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            MOut.G().println("stunnel install fail");
            e.printStackTrace();
        }
        finally {
            try {
                if (lock != null) {
                    lock.release();
                }
                channel.close();
            }
            catch (IOException e) {
                MOut.G().println("close lock file fail");
                e.printStackTrace();
            }
        }
    }

    public static void addHostTolConfig(StunnelParameters parameters, String path, int CAMode, BaseStunnel stunnel) {
        String BMCIP = parameters.getBMCIP();
        String BMCPort = parameters.getBMCPort();
        String stunnelPort = parameters.getSturnnlPort();
        String stunnelIP = parameters.getStunnelIP();
        String command = parameters.getCommand();
        CAModeInterface caInterface = stunnel.getCaInterface();
        boolean removeLast = false;
        String str = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String OS = StunnelUtility.checkOS();
            boolean isHostInfo = false;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("HOST_") > -1) {
                    isHostInfo = true;
                }
                if (!isHostInfo && OS.indexOf("Windows") == -1 && str.indexOf("cert") > -1) {
                    String[] splitCert = str.split("=");
                    str = splitCert[0] + "=" + path + "mail.pem";
                    str.trim();
                }
                stringBuffer.append(str);
                stringBuffer.append("\r\n");
            }
            if (!removeLast) {
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("[HOST_" + command + "]");
            stringBuffer.append("\r\n");
            if (CAMode == 1) {
                stringBuffer.append("cert = " + path + "client.crt");
                stringBuffer.append("\r\n");
                stringBuffer.append("key = " + path + "client.key");
                stringBuffer.append("\r\n");
                stringBuffer.append("CAfile = " + path + "server.crt");
                stringBuffer.append("\r\n");
            } else if (CAMode == 2) {
                String[] CAFiles = caInterface.getCASource();
                stringBuffer.append("cert = " + path + CAFiles[0]);
                stringBuffer.append("\r\n");
                stringBuffer.append("key = " + path + CAFiles[1]);
                stringBuffer.append("\r\n");
                stringBuffer.append("CAfile = " + path + CAFiles[2]);
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("client = yes");
            stringBuffer.append("\r\n");
            stringBuffer.append("accept = " + stunnelIP + ":" + stunnelPort);
            stringBuffer.append("\r\n");
            stringBuffer.append("connect = " + BMCIP + ":" + BMCPort);
            stringBuffer.append("\r\n");
            stringBuffer.append("verify = 3");
            stringBuffer.append("\r\n");
            bufferedReader.close();
            PrintWriter writer = new PrintWriter(path + "stunnel.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
            writer.close();
        }
        catch (FileNotFoundException e) {
            MOut.G().println("Read BaseStunnel.CONFIG Failure");
        }
        catch (IOException e) {
            MOut.G().println(" BufferedReader  Failure");
        }
    }

    public static List<String> removeClosedHostFromConfig(String path) {
        ArrayList<String> list = new ArrayList<String>();
        String OS = StunnelUtility.checkOS();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(path + "stunnel.conf"));
            StringBuffer stringBuffer = new StringBuffer();
            String str = "";
            String lastStr = null;
            StringBuffer tempBuffer = new StringBuffer();
            boolean iskeepInConf = false;
            boolean skipSapce = false;
            boolean isHostInfo = false;
            while ((str = bufferedReader.readLine()) != null) {
                if (str.indexOf("HOST_") > -1) {
                    isHostInfo = true;
                }
                if (!isHostInfo && str.indexOf("CAfile") > -1) continue;
                if (str.indexOf("HOST_") > -1 || str.indexOf("client") > -1 && str.indexOf("=") > -1 || str.indexOf("accept") > -1 || str.indexOf("connect") > -1 || isHostInfo && str.indexOf("cert") > -1 || isHostInfo && str.indexOf("key") > -1 || isHostInfo && str.indexOf("CAfile") > -1) {
                    tempBuffer.append(str);
                    tempBuffer.append("\r\n");
                    if (str.indexOf("accept") > -1) {
                        String[] splitAccept = str.split(":");
                        String stunnelPort = splitAccept[1].trim();
                        if (OS.indexOf("Windows") > -1) {
                            if (StunnelUtility.isHostStillConnectByJPS(stunnelPort)) {
                                iskeepInConf = true;
                            }
                        } else if (StunnelUtility.isHostStillConnectInLinux(path, stunnelPort)) {
                            iskeepInConf = true;
                        }
                        skipSapce = false;
                    }
                    if (str.indexOf("connect") <= -1) continue;
                    if (iskeepInConf) {
                        stringBuffer.append(tempBuffer.toString());
                    } else {
                        skipSapce = true;
                    }
                    iskeepInConf = false;
                    tempBuffer.setLength(0);
                    continue;
                }
                if (!str.equals(lastStr)) {
                    stringBuffer.append(str);
                } else {
                    skipSapce = true;
                }
                if (!skipSapce) {
                    stringBuffer.append("\r\n");
                }
                lastStr = str;
            }
            bufferedReader.close();
            PrintWriter writer = new PrintWriter(path + "stunnel.conf");
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
            writer.close();
        }
        catch (Exception e) {
            MOut.G().println("parseStunnelConfig failure ");
        }
        return list;
    }

    public static void startStunnel(String path, BaseStunnel stunnel) throws InterruptedException {
        String OS = StunnelUtility.checkOS();
        Process process = null;
        String absolutePath = "";
        String executeSource = stunnel.getNativeSource()[0];
        if (OS.indexOf("Windows") > -1) {
            try {
                absolutePath = path + executeSource;
                absolutePath = absolutePath.concat(" ");
                absolutePath = absolutePath.concat(path + "stunnel.conf");
                File file = new File(absolutePath);
                String cmd = file.toString();
                process = Runtime.getRuntime().exec(cmd);
                Thread.sleep(5000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                absolutePath = path + executeSource;
                File stunnelExeFile = new File(absolutePath);
                stunnelExeFile.setExecutable(true);
                absolutePath = absolutePath.concat(" ");
                absolutePath = absolutePath.concat(path + "stunnel.conf");
                File file = new File(absolutePath);
                String cmd = file.toString();
                process = Runtime.getRuntime().exec(cmd);
                Thread.sleep(5000L);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCreateTempFile(FileInputStream paramInputStream, File paramFile, String tempFilePath) {
        FileChannel srcChannel = paramInputStream.getChannel();
        RandomAccessFile destFile = null;
        FileChannel destChannel = null;
        FileLock destLock = null;
        if (!paramFile.exists()) {
            try {
                destFile = new RandomAccessFile(paramFile, "rw");
                destChannel = destFile.getChannel();
                destLock = destChannel.lock();
                File isExit = new File(tempFilePath);
                if (isExit.exists() && isExit.length() > 0L) {
                } else {
                    StunnelUtility.copyFileChannels(srcChannel, destChannel);
                }
            }
            catch (IOException e) {
                MOut.G().println("CreateTempFile Failed " + e);
            }
            finally {
                try {
                    if (destLock != null) {
                        destLock.release();
                    }
                    if (destChannel != null) {
                        destChannel.close();
                    }
                    srcChannel.close();
                    paramInputStream.close();
                    String e = StunnelUtility.checkOS();
                }
                catch (Exception e) {
                    MOut.G().println("close CreateTempFile Failed " + e);
                }
            }
        }
    }

    protected static void copyFileChannels(FileChannel src, FileChannel dest) throws IOException {
        long count;
        long size = src.size();
        int s_byteBuffer = 10240;
        for (long pos = 0L; pos < size; pos += dest.transferFrom(src, pos, count)) {
            count = size - pos > (long)s_byteBuffer ? (long)s_byteBuffer : size - pos;
        }
    }

    public static int getRandomConnectPort() {
        long startTime = System.currentTimeMillis();
        int port = (int)(Math.random() * 15536.0 + 50000.0);
        while (StunnelUtility.isPortUsed(port)) {
            port = (int)(Math.random() * 15536.0 + 50000.0);
            long endTime = System.currentTimeMillis();
            if ((endTime - startTime) / 1000L <= 5L) continue;
            port = 49999;
            break;
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isPortUsed(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        boolean result = true;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            result = false;
            return result;
        }
        catch (IOException e) {
            result = true;
            e.getStackTrace();
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException e) {
                    e.getStackTrace();
                }
            }
            return result;
        }
    }

    public static int getPIDinLinux(String path, String executeSource) {
        int pid = -1;
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", path + executeSource});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            String[] splitOutput = null;
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i).indexOf("grep") >= 0) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = output.split(" ");
                pid = Integer.parseInt(splitOutput[1]);
            }
        }
        catch (Exception e) {
            MOut.G().println("get PID Failed");
        }
        return pid;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = StunnelUtility.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static List<String> readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return StunnelUtility.readLines(reader);
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    static boolean isHostStillConnectByJPS(String stunnelPort) {
        File bundleJRe;
        File jre = new File("jre");
        String jps = "jps.exe";
        if (jre.isDirectory() && (bundleJRe = new File(".\\jre\\bin\\jps.exe")).exists()) {
            jps = ".\\jre\\bin\\jps.exe";
        }
        ProcessBuilder builder = new ProcessBuilder(jps, "-lm");
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        try {
            Process process = builder.start();
            process.waitFor();
            inputStream = process.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String str = "";
            while ((str = bufferedReader.readLine()) != null) {
                String[] splitStr;
                if (str.indexOf(KVMJAR) <= -1 && str.indexOf(SCJAR) <= -1 && str.indexOf(KOJAR) <= -1 || !stunnelPort.equals((splitStr = str.split(" "))[6])) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warning: jps not support");
        }
        return false;
    }

    static boolean isHostStillConnectByTaskList(String stunnelPort) {
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"tasklist", "/v"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"findstr", "java"});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            for (int i = 0; i < result.size(); ++i) {
                output = result.get(i);
                if ((output = output.replaceAll("\\s{1,}", " ").trim()).indexOf(KVM) <= -1 && output.indexOf(SC) <= -1 && output.indexOf(KO) <= -1 || output.indexOf(stunnelPort) <= -1) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("Warning: tasklist not support");
        }
        return false;
    }

    static boolean isHostStillConnectInLinux(String path, String stunnelPort) {
        String port = "";
        try {
            Process p1 = Runtime.getRuntime().exec(new String[]{"ps", "-ef"});
            InputStream input = p1.getInputStream();
            Process p2 = Runtime.getRuntime().exec(new String[]{"grep", "java"});
            OutputStream outputStream = p2.getOutputStream();
            StunnelUtility.copy(input, outputStream);
            outputStream.close();
            List<String> result = StunnelUtility.readLines(p2.getInputStream());
            String output = "";
            String[] splitOutput = null;
            int index = 0;
            for (int i = 0; i < result.size(); ++i) {
                index = result.get(i).indexOf(KVMJAR);
                if (index <= -1 && (index = result.get(i).indexOf(SCJAR)) <= -1 && (index = result.get(i).indexOf(KOJAR)) <= -1) continue;
                output = result.get(i);
                output = output.replaceAll("\\s{1,}", " ").trim();
                splitOutput = (output = output.substring(index).trim()).split(" ");
                port = splitOutput[4];
                if (!stunnelPort.equals(port)) continue;
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("ps -ef | grep java failure");
        }
        return false;
    }

    public static InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return null;
    }

    public static String checkOS() {
        return System.getProperty("os.name") + ":" + System.getProperty("os.arch");
    }

    public static boolean isIPv6(String ip) {
        try {
            InetAddress localInetAddress = InetAddress.getByName(ip);
            if (localInetAddress instanceof Inet6Address) {
                return true;
            }
        }
        catch (Exception e) {
            MOut.G().println("parse ip format fail");
        }
        return false;
    }

    public static String getJarPath(Class myClass) {
        String jarDir = "";
        try {
            CodeSource codeSource = myClass.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            jarDir = jarFile.getParentFile().getPath();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jarDir;
    }

    public static int getStunnelVerOnPowerBoard(IPMIInterface IPMIInterface2) throws Exception {
        int CAMode = 0;
        IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
        ipmiOEMPortServiceCommand.setIPMIInterface(IPMIInterface2);
        int stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
        switch (stunnelVer) {
            case 7: {
                CAMode = 2;
                break;
            }
            default: {
                CAMode = 1;
            }
        }
        return CAMode;
    }

    public static String getTmpDir() {
        String tempDIR = System.getProperty("java.io.tmpdir");
        if (!File.separator.equals(tempDIR.substring(tempDIR.length() - 1, tempDIR.length()))) {
            tempDIR = tempDIR + File.separator;
        }
        return tempDIR;
    }

    public static void main(String[] args) {
        StunnelUtility utility = new StunnelUtility();
        String OS = utility.checkOS();
        WindowsStunnel stunnel = new WindowsStunnel(OS);
        String tempDIR = System.getProperty("java.io.tmpdir");
        tempDIR = tempDIR + File.separator + "stunnel" + File.separator;
        StunnelUtility.removeClosedHostFromConfig(tempDIR);
    }
}

