/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.stunnel;

import com.supermicro.ipmi.stunnel.BaseStunnel;
import com.supermicro.ipmi.stunnel.Linux32Stunnel;
import com.supermicro.ipmi.stunnel.Linux64Stunnel;
import com.supermicro.ipmi.stunnel.MACStunnel;
import com.supermicro.ipmi.stunnel.WindowsStunnel;

public class StunnelFacotry {
    public static final String WINDOWS_DIRECTORY = "win";
    public static final String LINUX_DIRECTORY = "linux";
    public static final String MAC_DIRECTORY = "mac";

    public static BaseStunnel createStunnel(String OS) {
        if (OS.indexOf("Windows") > -1) {
            return new WindowsStunnel(WINDOWS_DIRECTORY);
        }
        if (OS.toLowerCase().indexOf(MAC_DIRECTORY) > -1) {
            return new MACStunnel(MAC_DIRECTORY);
        }
        if (OS.indexOf("64") > -1) {
            return new Linux64Stunnel(LINUX_DIRECTORY);
        }
        return new Linux32Stunnel(LINUX_DIRECTORY);
    }

    public static BaseStunnel createStunnel(String OS, int CAMode) {
        if (OS.indexOf("Windows") > -1) {
            return new WindowsStunnel(WINDOWS_DIRECTORY, CAMode);
        }
        if (OS.toLowerCase().indexOf(MAC_DIRECTORY) > -1) {
            return new MACStunnel(MAC_DIRECTORY, CAMode);
        }
        if (OS.indexOf("64") > -1) {
            return new Linux64Stunnel(LINUX_DIRECTORY, CAMode);
        }
        return new Linux32Stunnel(LINUX_DIRECTORY, CAMode);
    }
}

