/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

public class SensorDefine {
    private final int id;
    private final String name;
    private final byte eventType;
    private final byte sensorType;
    private final String unit;
    private final boolean isEventOnly;

    private SensorDefine(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.eventType = builder.eventType;
        this.sensorType = builder.sensorType;
        this.unit = builder.unit;
        this.isEventOnly = builder.isEventOnly;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte getEventType() {
        return this.eventType;
    }

    public byte getSensorType() {
        return this.sensorType;
    }

    public String getUnit() {
        if (this.unit != null) {
            return this.unit;
        }
        switch (this.sensorType) {
            case 1: {
                return "C";
            }
            case 2: {
                return "V";
            }
            case 4: {
                return "RPM";
            }
        }
        return "";
    }

    public boolean isEventOnly() {
        return this.isEventOnly;
    }

    public static class Builder {
        private final int id;
        private final String name;
        private byte eventType;
        private byte sensorType;
        private String unit;
        private boolean isEventOnly = false;

        public Builder(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public Builder eventType(byte eventType) {
            this.eventType = eventType;
            return this;
        }

        public Builder sensorType(byte sensorType) {
            this.sensorType = sensorType;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder eventOnly() {
            this.isEventOnly = true;
            return this;
        }

        public SensorDefine build() {
            return new SensorDefine(this);
        }
    }
}

