/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.dcmi;

import java.util.Arrays;
import nn.pp.drvredir.ByteUtility;

public class EnhancedPowerStatAttr {
    private static final int OFF_MAJOR_VER = 1;
    private static final int OFF_MINOR_VER = 2;
    private static final int OFF_PARAM_VER = 3;
    private static final int OFF_NUM_OF_SUPPORTED_PERIODS = 4;
    private static final int BIT_MASK_TIME_UNIT = 192;
    private static final int BIT_OFF_TIME_UNIT = 6;
    private static final int BIT_MASK_TIME_DURATION = 63;
    public final int majorVersion;
    public final int minorVersion;
    public final int parameterVersion;
    public final int numOfsuuportedPeriods;
    public final byte[] periods;

    public EnhancedPowerStatAttr(byte[] raw) {
        this.majorVersion = raw[1];
        this.minorVersion = raw[2];
        this.parameterVersion = raw[3];
        this.numOfsuuportedPeriods = raw[4];
        this.periods = Arrays.copyOfRange(raw, 5, raw.length);
    }

    public String toReadableString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Enhanced Power Statistics attributes\n");
        sb.append("DCMI Version      :" + this.majorVersion + "." + this.minorVersion + "\n");
        sb.append("Parameter Revision:" + this.parameterVersion + "\n");
        sb.append("The number of supported rolling average time periods:" + this.numOfsuuportedPeriods + "\n");
        sb.append("Rolling Average Time periods:\n");
        sb.append(this.getPeriodString());
        return sb.toString();
    }

    public String getPeriodString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.periods.length; ++i) {
            sb.append("\t" + ByteUtility.byteToHex(this.periods[i]) + " - " + EnhancedPowerStatAttr.getTimeDuration(this.periods[i]) + " " + EnhancedPowerStatAttr.getTimeUnit(this.periods[i]) + "\n");
        }
        return sb.toString();
    }

    public static int getTimeDuration(byte period) {
        return period & 0x3F;
    }

    public static String getTimeUnit(byte period) {
        int unit = (period & 0xC0) >> 6;
        switch (unit) {
            case 0: {
                return "Seconds";
            }
            case 1: {
                return "Minutes";
            }
            case 2: {
                return "Hours";
            }
            case 3: {
                return "Days";
            }
        }
        return "Undefined unit";
    }
}

