/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import java.util.HashMap;
import java.util.Map;

public class SetNodeManagerPowerDrawRange {
    private static final Map<String, String> completionCodeToString = new HashMap<String, String>();
    private IPMINM20Command ipmiCommand;
    private byte domainId;
    private byte[] minPowerDraw;
    private byte[] maxPowerDraw;

    public SetNodeManagerPowerDrawRange(IPMINM20Command ipmiCommand, byte domainId, byte[] minPowerDraw, byte[] maxPowerDraw) {
        this.ipmiCommand = ipmiCommand;
        this.domainId = domainId;
        this.minPowerDraw = minPowerDraw;
        this.maxPowerDraw = maxPowerDraw;
    }

    public void execute() throws IPMIException {
        IPMIMessage resMessage = this.ipmiCommand.setNodeManagerPowerDrawRangeCommand(this.domainId, this.minPowerDraw, this.maxPowerDraw);
        if (resMessage != null) {
            if (resMessage.completionCode != 0) {
                throw Common.cCodeToException(completionCodeToString, resMessage);
            }
        } else {
            throw new IPMIException("Call SetNodeManagerPowerDrawRange failed");
        }
    }

    static {
        completionCodeToString.put("81", "Domain ID invalid or not supported in the currentconfiguration.");
        completionCodeToString.put("C9", "Parameter out of range. Returned when Minimum Power Draw Range exceeds the Maximum one.");
    }
}

