/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.nm.Common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PolicySuspendPeriods {
    public static final int MAX_NUM_OF_PERIODS = 5;
    private static final int NUM_OF_BYTE_PER_PERIOD = 3;
    private static final int MIN_DATA_LENGTH = Common.INTEL_MANUFACTURERS_ID.length + 1;
    private static final int MAX_DATA_LENGTH = MIN_DATA_LENGTH + 15;
    private static final int OFF_NUMBER_OF_PERIODS = 3;
    private static final int OFF_PERIODS = 4;
    private byte[] raw;
    public final int numOfPeriods;
    public final Period[] periods = new Period[5];

    public PolicySuspendPeriods(byte[] raw) throws IPMIException {
        if (raw.length > MAX_DATA_LENGTH || raw.length < MIN_DATA_LENGTH) {
            throw new IPMIException("Invalid Length");
        }
        this.raw = raw;
        this.numOfPeriods = raw[3];
        int period_off = 4;
        for (int i = 0; i < this.numOfPeriods; ++i) {
            this.periods[i] = new Period(raw[period_off + 0], raw[period_off + 1], raw[period_off + 2]);
            period_off += 3;
        }
    }

    public byte[] getRawOfPeriods() {
        return Arrays.copyOfRange(this.raw, 4, this.raw.length);
    }

    public void toReadableString() {
        System.out.println("Number Of Periods = " + this.numOfPeriods);
        for (int i = 0; i < this.numOfPeriods; ++i) {
            System.out.println("[Suspend Periods " + (i + 1) + "]");
            System.out.println("\tStart = " + this.formatTimeString(this.periods[i].start_hr, this.periods[i].start_min));
            System.out.println("\tStop  = " + this.formatTimeString(this.periods[i].stop_hr, this.periods[i].stop_min));
            if (this.periods[i].days.size() == 0) {
                System.out.println("\tDays  = Not set");
                continue;
            }
            System.out.println("\tDays  = " + this.joinDayString(this.periods[i].days));
        }
    }

    private String formatTimeString(int h, int m) {
        return String.format("%02d:%02d", h, m);
    }

    private String joinDayString(List<String> days) {
        StringBuilder sb = new StringBuilder();
        for (String s : days) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toString() {
        return "PolicySuspendPeriods [numOfPeriods=" + this.numOfPeriods + ", periods=" + Arrays.toString(this.periods) + "]";
    }

    public static class Period {
        private static final String[] DAY = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        public final int start_hr;
        public final int start_min;
        public final int stop_hr;
        public final int stop_min;
        public final List<String> days = new ArrayList<String>();

        public Period(byte start, byte stop, byte recurrencePattern) {
            this.start_hr = (start & 0xFF) / 10;
            this.start_min = (start & 0xFF) % 10 * 6;
            this.stop_hr = (stop & 0xFF) / 10;
            this.stop_min = (stop & 0xFF) % 10 * 6;
            this.parseRecurrencePattern(recurrencePattern);
        }

        private void parseRecurrencePattern(byte recurrencePattern) {
            for (int i = 0; i < 7; ++i) {
                if (this.getBit(recurrencePattern, i) != 1) continue;
                this.days.add(DAY[i]);
            }
        }

        private byte getBit(byte src, int position) {
            return (byte)(src >> position & 1);
        }

        public String toString() {
            return "Period [start_hr=" + this.start_hr + ", start_min=" + this.start_min + ", stop_hr=" + this.stop_hr + ", stop_min=" + this.stop_min + ", days=" + this.days + "]";
        }
    }
}

