/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class FRU_Board {
    public byte formatVersion = 1;
    public byte length;
    public byte languageCode = 0;
    public byte[] mfgDateTime = new byte[3];
    public byte boardManufacturerLength;
    public byte[] boardManufacturer = new byte[0];
    public byte boardProductNameLength;
    public byte[] boardProductName = new byte[0];
    public byte boardSerialNumberLength;
    public byte[] boardSerialNumber = new byte[0];
    public byte boardPartNumberLength;
    public byte[] boardPartNumber = new byte[0];
    public byte boardFruFileIDLength;
    public byte[] boardFruFileID = new byte[0];
    public byte[] customBoardInfo = new byte[0];
    public byte endOfInfoField = (byte)-63;
    public byte checkSum;

    public byte[] toRaw() {
        int i;
        this.checkSum = 0;
        int size = 10 + this.mfgDateTime.length + this.boardManufacturer.length + this.boardProductName.length + this.boardSerialNumber.length + this.boardPartNumber.length + this.boardFruFileID.length + this.customBoardInfo.length;
        int padSize = 8 - size % 8;
        if (padSize == 8) {
            padSize = 0;
        }
        byte[] raw = new byte[size + padSize];
        int index = 0;
        raw[index] = this.formatVersion;
        raw[++index] = (byte)(raw.length / 8);
        raw[++index] = this.languageCode;
        System.arraycopy(this.mfgDateTime, 0, raw, ++index, this.mfgDateTime.length);
        raw[index += this.mfgDateTime.length] = this.boardManufacturerLength = (byte)(192 + this.boardManufacturer.length);
        System.arraycopy(this.boardManufacturer, 0, raw, ++index, this.boardManufacturer.length);
        raw[index += this.boardManufacturer.length] = this.boardProductNameLength = (byte)(192 + this.boardProductName.length);
        System.arraycopy(this.boardProductName, 0, raw, ++index, this.boardProductName.length);
        raw[index += this.boardProductName.length] = this.boardSerialNumberLength = (byte)(192 + this.boardSerialNumber.length);
        System.arraycopy(this.boardSerialNumber, 0, raw, ++index, this.boardSerialNumber.length);
        raw[index += this.boardSerialNumber.length] = this.boardPartNumberLength = (byte)(192 + this.boardPartNumber.length);
        System.arraycopy(this.boardPartNumber, 0, raw, ++index, this.boardPartNumber.length);
        raw[index += this.boardPartNumber.length] = this.boardFruFileIDLength = (byte)(192 + this.boardFruFileID.length);
        System.arraycopy(this.boardFruFileID, 0, raw, ++index, this.boardFruFileID.length);
        System.arraycopy(this.customBoardInfo, 0, raw, index += this.boardFruFileID.length, this.customBoardInfo.length);
        raw[index += this.customBoardInfo.length] = this.endOfInfoField;
        ++index;
        for (i = 0; i < padSize; ++i) {
            raw[index] = 0;
            ++index;
        }
        for (i = 0; i < raw.length - 1; ++i) {
            this.checkSum = (byte)(this.checkSum + raw[i]);
        }
        raw[index] = this.checkSum = (byte)(-this.checkSum);
        return raw;
    }

    public void testData() {
        this.customBoardInfo = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.boardFruFileID = "B_FRUID123".getBytes();
    }
}

