/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserListCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int numberOfAvailableUser = ipmiMessagingCommand.getNumberOfAvailableUser();
        int countOfCurrentEnabledUser = ipmiMessagingCommand.getCountOfCurrentEnabledUser();
        MOut.G(this).println("Maximum number of Users          : " + numberOfAvailableUser);
        MOut.G(this).println("Count of currently enabled Users : " + countOfCurrentEnabledUser);
        String formatTemplate = "%8s | %-15s | %-18s | %-12s \n";
        MOut.G(this).printf(formatTemplate, "User ID", "User Name", "Privilege Level", "Enable");
        MOut.G(this).printf(formatTemplate, "-------", "-----------", "---------------", "------");
        for (int i = 2; i <= numberOfAvailableUser; ++i) {
            String name = ipmiMessagingCommand.getUserNameByID((byte)i);
            if (name == null || name.length() == 0) continue;
            byte privilege = ipmiMessagingCommand.getUserPrivilegeByID((byte)i);
            if (this.config.getPrivilege() < privilege) continue;
            boolean isEnabled = ipmiMessagingCommand.isEnableUser((byte)i);
            MOut.G(this).printf(formatTemplate, "" + i, name, this.getPriviledgeString(privilege), isEnabled ? "Yes" : "No");
        }
        this.statusCode = 0;
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "Callback";
            }
            case 15: {
                return "No Access";
            }
        }
        return "";
    }
}

