/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.IPMITASCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class NVMELocateSSDCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && this.parameters.length == 3) {
            this.aoc = 0;
            this.slot = 0;
            this.group = 0;
            try {
                this.aoc = Byte.parseByte(this.parameters[0], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
            try {
                this.group = Byte.parseByte(this.parameters[1], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
            try {
                this.slot = Byte.parseByte(this.parameters[2], 10);
            }
            catch (NumberFormatException e) {
                MOut.G(this).println(e.getMessage());
                this.statusCode = 147;
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMITASCommand ipmiTasCommand = new IPMITASCommand(null);
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiTasCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters == null) {
            this.printUsage();
            this.statusCode = 0;
            return;
        }
        if (this.parameters.length == 1) {
            String result = new String();
            if (!ipmiTasCommand.checkTASAlive()) {
                this.statusCode = 0;
                return;
            }
            int deviceCount = ipmiTasCommand.getNVMEDeviceCount();
            byte[] key = IPMITASCommand.getModifiedMacAsKey();
            char ch = this.parameters[0].charAt(this.parameters[0].length() - 2);
            int number = ch >= '0' && ch <= '9' ? Integer.parseInt(this.parameters[0].substring(this.parameters[0].length() - 2)) : Integer.parseInt(this.parameters[0].substring(this.parameters[0].length() - 1));
            if (!ipmiTasCommand.isFlagAvailable()) {
                MOut.G(this).println("TAS command area has been occupied, please resend the command later.");
                this.statusCode = 0;
                return;
            }
            for (int i = 0; i < deviceCount; ++i) {
                int j;
                if (!this.parameters[0].equalsIgnoreCase(ipmiTasCommand.getNvmeDeviceName(i))) continue;
                int offset = 0;
                int lengthCount = 0;
                byte currentLength = 0;
                int TotalLength = ipmiTasCommand.getSmartTotalDataLength(i);
                do {
                    byte[] data = ipmiTasCommand.getSmartRetunInfo(i, offset);
                    currentLength = data[6];
                    byte[] smartInfo = new byte[currentLength];
                    System.arraycopy(data, 7, smartInfo, 0, currentLength);
                    offset += 32;
                    result = result + new String(smartInfo);
                } while ((lengthCount += currentLength) < TotalLength);
                IPMITASCommand.SmartInfo smartStructure = ipmiTasCommand.createSmartStructure(result);
                ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
                boolean isMatchOOBSerial = false;
                block2: for (j = 0; j < nvmeAOCInfos.size(); ++j) {
                    for (int k = 0; k < nvmeAOCInfos.get((int)j).aocGroups.size(); ++k) {
                        if (!nvmeAOCInfos.get((int)j).aocGroups.get(k).isMatchSerialNumber(smartStructure.serialNumber)) continue;
                        isMatchOOBSerial = true;
                        continue block2;
                    }
                }
                if (isMatchOOBSerial) {
                    byte[] response;
                    ipmiTasCommand.setNvmeLocatebyKey(key, number);
                    j = 0;
                    while ((response = ipmiTasCommand.getCommandResponse()) == null) {
                        Thread.sleep(1000L);
                        if (++j < 10) continue;
                    }
                    if (response == null) {
                        MOut.G(this).println("Command timeOut, please try again.");
                        this.statusCode = 149;
                        return;
                    }
                    if (IPMITASCommand.compareKeyFromResponse(key, response)) {
                        MOut.G(this).println("Done");
                        this.statusCode = 0;
                    } else {
                        MOut.G(this).println("Command fail, please try again.");
                        this.statusCode = 149;
                    }
                    return;
                }
                MOut.G().println("In band locate/stopLocate function fail due to serial number missmatch");
                this.statusCode = 0;
                return;
            }
            MOut.G().println("Can't find device name.");
            this.statusCode = 0;
        } else if (this.parameters.length == 3) {
            ArrayList<IPMINVMECommand.NVMEAOCInfo> nvmeAOCInfos = ipmiNVMECommand.getAll();
            if (nvmeAOCInfos == null) {
                this.statusCode = 153;
                MOut.G(this).println("No NVME info");
                return;
            }
            if (ipmiNVMECommand.isGroupingWithCPU()) {
                this.group = (byte)(this.group - 1);
            } else {
                this.slot = nvmeAOCInfos.get((int)0).aocGroups.get((int)0).slotPerGroup == 24 ? (byte)(this.slot % 24) : (byte)(this.slot % 12);
            }
            ipmiNVMECommand.setLocate(this.aoc, this.slot, (byte)0, this.group);
            MOut.G(this).println("Done");
            this.statusCode = 0;
        } else {
            this.printUsage();
            this.statusCode = 0;
        }
    }

    public void printUsage() {
        MOut.G(this).println("Usage1: nvme locate <HDD name>");
        MOut.G(this).println("Usage2: nvme locate <aoc> <group> <slot>");
    }
}

