/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Host;
import com.supermicro.ipmi.text.HostManager;
import com.supermicro.ipmi.text.MOut;

public class HostAddCommand
extends Command {
    @Override
    public void execute() throws Exception {
        String hostname = null;
        String ip = null;
        String id = null;
        String pw = null;
        if (this.getParameters() == null || this.getParameters().length < 2) {
            MOut.G(this).println("hostname and IP are required");
            this.statusCode = 147;
            return;
        }
        hostname = this.getParameters()[0];
        ip = this.getParameters()[1];
        if (this.getParameters().length >= 3) {
            id = this.getParameters()[2];
        }
        if (this.getParameters().length >= 4) {
            pw = this.getParameters()[3];
        }
        if (!IPMILanCommand.isIPAddress(ip)) {
            MOut.G(this).println("IP format error !");
            this.statusCode = 147;
            return;
        }
        if (HostManager.getInstance().findHost(hostname) != null) {
            MOut.G(this).println("Host name duplicated !");
            this.statusCode = 147;
            return;
        }
        Host host = new Host();
        host.setName(hostname);
        host.setIp(ip);
        if (id != null) {
            host.setUsername(id);
        }
        if (pw != null) {
            host.setPassword(pw);
        }
        HostManager.getInstance().addHost(host);
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

