/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.RandomAccessFile;

public class IPMIPowerSupplyFWUpdater
extends IPMICommand {
    MOut mout = MOut.G();
    public static int signedDataLength = 1416;
    IPMIMessagingCommand ipmiMessageCommand;
    IPMII2CPMBusCommand ipmiI2CPMBusCommand;
    IPMIChassisCommand ipmiChassisCommand;
    String firmwareName;

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMIPowerSupplyFWUpdater(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(ipmiInterface);
        this.ipmiChassisCommand = new IPMIChassisCommand(ipmiInterface);
    }

    @Override
    public void setIPMIInterface(IPMIInterface ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
        this.ipmiMessageCommand = new IPMIMessagingCommand(ipmiInterface);
        this.ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(ipmiInterface);
        this.ipmiChassisCommand = new IPMIChassisCommand(ipmiInterface);
    }

    public void update(byte slaveAddr) throws Exception {
        int pwsVersion;
        int fileVersion;
        int currentProgress = 0;
        int lastProgress = 0;
        long start = System.currentTimeMillis();
        if (!this.ipmiI2CPMBusCommand.checkIfPMBusSlaveAddrWorks(slaveAddr)) {
            throw new Exception("Invalid Slave address");
        }
        IPMII2CPMBusCommand iPMII2CPMBusCommand = this.ipmiI2CPMBusCommand;
        iPMII2CPMBusCommand.getClass();
        this.ipmiI2CPMBusCommand.bootLoader = iPMII2CPMBusCommand.new IPMII2CPMBusCommand.PSUBootLoader(slaveAddr);
        PWSInfo pwsInfo = this.getPWSInfo(slaveAddr);
        if (!pwsInfo.isSupportFWUpdate) {
            throw new Exception("This power supply does not support firmware update");
        }
        FirmwareFile fwfile = new FirmwareFile(this.firmwareName);
        fwfile.load();
        if (!pwsInfo.getModelNameString().equals(fwfile.getFirmwareImageHeader().getModelNameString())) {
            throw new Exception("Model type mismatch");
        }
        if (!pwsInfo.isSupportPSONUpdate() && this.ipmiChassisCommand.isPowerOn()) {
            throw new Exception("This power supply doesn't support firmware update in PSON state");
        }
        if (fwfile.firmwareImageHeader.fwMajor == pwsInfo.fwVer[0] && fwfile.firmwareImageHeader.fwMinorPrimary == pwsInfo.fwVer[1] && fwfile.firmwareImageHeader.fwMinorSecondary == (byte)(pwsInfo.fwVer[2] & 0x7F)) {
            throw new Exception("FW file is the same version as PWS, no need to update.");
        }
        if (pwsInfo.pwsRevision[3] != fwfile.firmwareImageHeader.hwRevisionFirst || pwsInfo.pwsRevision[5] != fwfile.firmwareImageHeader.hwRevisionSecond) {
            throw new Exception("Invalid FW file, different HW Revision from PWS");
        }
        if (!pwsInfo.isAllowDownGrade() && (fileVersion = fwfile.firmwareImageHeader.fwMajor * 100 + fwfile.firmwareImageHeader.fwMinorPrimary * 10 + fwfile.firmwareImageHeader.fwMinorSecondary) < (pwsVersion = pwsInfo.fwVer[0] * 100 + pwsInfo.fwVer[1] * 10 + pwsInfo.fwVer[2])) {
            throw new Exception("This device does not allow FW down grade.");
        }
        this.mout.println("PWS Info:");
        this.mout.println(pwsInfo.toString());
        this.mout.println("Firmware Info:");
        this.mout.println(fwfile.toString());
        this.ipmiI2CPMBusCommand.enterFWUpdateMode();
        this.mout.print("Progress:|");
        int totalSize = fwfile.raw.length - signedDataLength;
        int bSize = fwfile.getFirmwareImageHeader().getBlockSize();
        if (bSize == 0) {
            bSize = 64;
        }
        int writeTime = fwfile.getFirmwareImageHeader().getWriteTime();
        for (int i = 0; i < totalSize / bSize; ++i) {
            byte[] raw = new byte[bSize + 1];
            raw[0] = (byte)bSize;
            System.arraycopy(fwfile.raw, i * bSize, raw, 1, bSize);
            this.ipmiI2CPMBusCommand.setMFR_FWUPLOAD(raw);
            try {
                Thread.sleep(writeTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            currentProgress = i * 100 / (totalSize / bSize);
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        byte result = this.ipmiI2CPMBusCommand.getMFR_FWUPLOAD_STATUS();
        if (!this.isFWUploadDone(result)) {
            throw new Exception(this.getFWUploadStatusString(result));
        }
        this.mout.println(this.getFWUploadStatusString(result));
        this.ipmiI2CPMBusCommand.exitFWUpdateMode();
        System.out.println("Done");
        this.printTimeString("Upload Time", System.currentTimeMillis() - start);
    }

    private void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public PWSInfo getPWSInfo(byte slaveAddr) throws Exception {
        this.ipmiI2CPMBusCommand.detectBusID();
        this.ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
        IPMII2CPMBusCommand iPMII2CPMBusCommand = this.ipmiI2CPMBusCommand;
        iPMII2CPMBusCommand.getClass();
        this.ipmiI2CPMBusCommand.bootLoader = iPMII2CPMBusCommand.new IPMII2CPMBusCommand.PSUBootLoader(slaveAddr);
        byte compatibility = this.ipmiI2CPMBusCommand.getMFR_FWUPLOAD_CAPABILITY();
        byte[] fwVerBytes = this.ipmiI2CPMBusCommand.getMFR_FW_REVISION();
        byte[] hwVerBytes = this.ipmiI2CPMBusCommand.getMFR_REVISION();
        byte[] modelBytes = this.ipmiI2CPMBusCommand.getMFR_MODEL();
        boolean isSupportFWUpdate = this.checkIfSupportFWUpdate(slaveAddr);
        PWSInfo pwsInfo = new PWSInfo();
        pwsInfo.isSupportFWUpdate = isSupportFWUpdate;
        pwsInfo.compatibility = compatibility;
        pwsInfo.fwVer = fwVerBytes;
        pwsInfo.pwsRevision = hwVerBytes;
        pwsInfo.modelName = modelBytes;
        return pwsInfo;
    }

    public boolean checkIfSupportFWUpdate(byte slaveAddr) throws Exception {
        this.ipmiI2CPMBusCommand.detectBusID();
        this.ipmiI2CPMBusCommand.setSlaveAddr(slaveAddr);
        IPMII2CPMBusCommand iPMII2CPMBusCommand = this.ipmiI2CPMBusCommand;
        iPMII2CPMBusCommand.getClass();
        this.ipmiI2CPMBusCommand.bootLoader = iPMII2CPMBusCommand.new IPMII2CPMBusCommand.PSUBootLoader(slaveAddr);
        this.ipmiI2CPMBusCommand.setMFR_FWUPLOAD_MODE((byte)1);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte mode = this.ipmiI2CPMBusCommand.getMFR_FWUPLOAD_MODE();
        this.ipmiI2CPMBusCommand.setMFR_FWUPLOAD_MODE((byte)0);
        boolean result2 = true;
        try {
            byte cap = this.ipmiI2CPMBusCommand.getMFR_FWUPLOAD_CAPABILITY();
            if (cap == -1 || cap == 0 || cap > 8) {
                result2 = false;
            }
        }
        catch (Exception e) {
            result2 = false;
        }
        return mode == 1 && result2;
    }

    public boolean isFWUploadDone(byte result) {
        return (result & 1) == 1;
    }

    public String getFWUploadStatusString(byte result) {
        String str = "";
        switch (result) {
            case 1: {
                str = "Full image received successfully";
                break;
            }
            case 2: {
                str = "Full image not received yet.The PSU will keep this bit asserted until the full image is received by the PSU.";
                break;
            }
            case 4: {
                str = "Full image received but image is bad or corrupt. Power supply can power ON, but only in \u00a1\u00a5safe mode\u00a1\u00a6 with minimal operating capability";
                break;
            }
            case 8: {
                str = "Full image received but image is bad or corrupt. Power supply can power ON and support full features";
                break;
            }
            case 16: {
                str = "FW image not supported by PSU. If the PSU receives the image header and determines that the PSU HW does not support the image being sent by the system; it shall not accept the image and it shall assert this bit.";
                break;
            }
            default: {
                str = "Unknown status (" + ByteUtility.byteToHex(result) + "h)";
            }
        }
        return str;
    }

    public String getFirmwareName() {
        return this.firmwareName;
    }

    public void setFirmwareName(String firmwareName) {
        this.firmwareName = firmwareName;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.140");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIPowerSupplyFWUpdater ipmiPowerSupplyFWUpdater = new IPMIPowerSupplyFWUpdater(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiPowerSupplyFWUpdater);
        if (sessionController == null) {
            return;
        }
        try {
            byte slaveAddr = -80;
            PWSInfo pwsInfo = ipmiPowerSupplyFWUpdater.getPWSInfo(slaveAddr);
            System.out.println(pwsInfo.toString());
            System.out.println("FW File Info: ");
            IPMIPowerSupplyFWUpdater iPMIPowerSupplyFWUpdater = ipmiPowerSupplyFWUpdater;
            iPMIPowerSupplyFWUpdater.getClass();
            FirmwareFile f = iPMIPowerSupplyFWUpdater.new FirmwareFile("c:\\PWS2.bin");
            f.load();
            System.out.println(f.getFirmwareImageHeader().toDisplayString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }

    public static void main_file(String[] args) throws Exception {
        IPMIPowerSupplyFWUpdater ipmiPowerSupplyFWUpdater;
        IPMIPowerSupplyFWUpdater iPMIPowerSupplyFWUpdater = ipmiPowerSupplyFWUpdater = new IPMIPowerSupplyFWUpdater(null);
        iPMIPowerSupplyFWUpdater.getClass();
        FirmwareFile f = iPMIPowerSupplyFWUpdater.new FirmwareFile("c:\\PWS.bin");
        f.load();
        System.out.println(f.getFirmwareImageHeader().toString());
        System.out.println(f.getFirmwareImageHeader().toDisplayString());
        System.out.println(ByteUtility.bytesToHex(f.raw));
        System.out.println("raw size =" + f.raw.length);
    }

    public class FirmwareImageHeader {
        byte[] crcByte = new byte[2];
        byte[] imageInfo = new byte[8];
        byte[] modelName = new byte[12];
        byte fwMajor;
        byte fwMinorPrimary;
        byte fwMinorSecondary;
        byte hwRevisionFirst;
        byte hwRevisionSecond;
        byte[] blockSize = new byte[2];
        byte[] writeTime = new byte[2];

        public String getModelNameString() {
            return new String(this.modelName);
        }

        public int getBlockSize() {
            return ByteUtility.twoBytesToInt(this.blockSize);
        }

        public int getWriteTime() {
            return ByteUtility.twoBytesToInt(this.writeTime);
        }

        public String getImageInfo() {
            return new String(this.imageInfo);
        }

        public void fromRaw(byte[] raw) throws Exception {
            int index = 0;
            System.arraycopy(raw, index, this.crcByte, 0, this.crcByte.length);
            System.arraycopy(raw, index += this.crcByte.length, this.imageInfo, 0, this.imageInfo.length);
            System.arraycopy(raw, index += this.imageInfo.length, this.modelName, 0, this.modelName.length);
            index += this.modelName.length;
            this.fwMajor = raw[++index];
            this.fwMinorPrimary = raw[++index];
            this.fwMinorSecondary = raw[++index];
            this.hwRevisionFirst = raw[++index];
            this.hwRevisionSecond = raw[++index];
            System.arraycopy(raw, ++index, this.blockSize, 0, this.blockSize.length);
            System.arraycopy(raw, index += this.blockSize.length, this.writeTime, 0, this.writeTime.length);
            index += this.writeTime.length;
        }

        public String toDisplayString() {
            byte[] hw1 = new byte[1];
            byte[] hw2 = new byte[1];
            hw1[0] = this.hwRevisionFirst;
            hw2[0] = this.hwRevisionSecond;
            String result = "";
            result = result + "FW Version   = " + this.fwMajor + "." + this.fwMinorPrimary + "." + this.fwMinorSecondary + "\n";
            result = result + "Model Name   = " + new String(this.modelName) + "\n";
            result = result + "PWS Revision = REV" + new String(hw1) + "." + new String(hw2) + "\n";
            result = result + "Image Info   = " + new String(this.imageInfo) + "\n";
            result = result + "block Size   = " + ByteUtility.twoBytesToInt(this.blockSize) + " bytes \n";
            result = result + "write Time   = " + ByteUtility.twoBytesToInt(this.writeTime) + " ms \n";
            return result;
        }

        public String toString() {
            String result = "";
            result = result + "crcByte =" + ByteUtility.bytesToHex(this.crcByte) + "\n";
            result = result + "imageInfo =" + new String(this.imageInfo) + ", " + ByteUtility.bytesToHex(this.imageInfo) + "\n";
            result = result + "modelName =" + new String(this.modelName) + ", " + ByteUtility.bytesToHex(this.modelName) + "\n";
            result = result + "fwMajor =" + ByteUtility.byteToHex(this.fwMajor) + "\n";
            result = result + "fwMinorPrimary =" + ByteUtility.byteToHex(this.fwMinorPrimary) + "\n";
            result = result + "fwMinorSecondary =" + ByteUtility.byteToHex(this.fwMinorSecondary) + "\n";
            result = result + "hwRevisionFirst =" + ByteUtility.byteToHex(this.hwRevisionFirst) + "\n";
            result = result + "hwRevisionSecond =" + ByteUtility.byteToHex(this.hwRevisionSecond) + "\n";
            result = result + "blockSize =" + ByteUtility.bytesToHex(this.blockSize) + "\n";
            result = result + "writeTime =" + ByteUtility.bytesToHex(this.writeTime) + "\n";
            return result;
        }
    }

    public class FirmwareFile {
        FirmwareImageHeader firmwareImageHeader;
        String filename;
        byte[] raw;

        public FirmwareFile(String filename) {
            this.filename = filename;
            this.firmwareImageHeader = new FirmwareImageHeader();
        }

        public void load() throws Exception {
            File f = new File(this.filename);
            if (!f.exists()) {
                throw new Exception("File is not exist");
            }
            if (f.length() != (long)(32832 + signedDataLength)) {
                throw new Exception("File size is not correct");
            }
            RandomAccessFile raf = new RandomAccessFile(this.filename, "r");
            byte[] header = new byte[32];
            raf.read(header);
            this.firmwareImageHeader.fromRaw(header);
            raf.seek(0L);
            this.raw = new byte[(int)raf.length()];
            raf.read(this.raw);
            raf.close();
        }

        public FirmwareImageHeader getFirmwareImageHeader() {
            return this.firmwareImageHeader;
        }

        public String toString() {
            String result = "";
            result = result + "Filename     = " + this.filename + "\n";
            result = result + this.firmwareImageHeader.toDisplayString();
            return result;
        }
    }

    public class PWSInfo {
        public boolean isSupportFWUpdate;
        public byte compatibility;
        public byte[] fwVer;
        public byte[] modelName;
        public byte[] pwsRevision;

        public String getModelNameString() {
            return new String(this.modelName);
        }

        public String toString() {
            String result = "";
            result = result + "Capability   = " + ByteUtility.byteToHex(this.compatibility) + "\n";
            result = result + "FW Version   = " + this.fwVer[0] + "." + this.fwVer[1] + "." + (this.fwVer[2] & 0x7F) + "\n";
            result = result + "Model Name   = " + new String(this.modelName) + "\n";
            result = result + "PWS Revision = " + new String(this.pwsRevision) + "\n";
            return result;
        }

        public boolean isSupportPSONUpdate() {
            return (this.compatibility & 6) > 0;
        }

        public boolean isAllowDownGrade() {
            return (this.fwVer[2] & 0x80) == 0;
        }
    }
}

