/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.KeyTranslator;

public class ButtonPanel
extends Panel {
    public static final boolean debug = false;
    ServerConsolePanelBase frame;
    KeyEventHandler keh;
    PrintStream logger;
    boolean monimode;
    int keypause;
    Vector buttons = new Vector();
    private int preferred_width = 500;
    private boolean use_preferred_width = false;
    static final int KEYDELI_ADD = 240;
    static final int KEYDELI_SEPERATE = 241;
    static final int KEYDELI_PAUSE = 242;

    public ButtonPanel(ServerConsolePanelBase frame, KeyEventHandler keh, String[] hotkeys, String[] hotkeycodes, String[] hotkeynames, PrintStream logger, boolean monimode, int keypause) {
        this.frame = frame;
        this.logger = logger;
        this.monimode = monimode;
        this.keh = keh;
        this.keypause = keypause;
        this.setLayout(new FlowLayout(0, 0, 0));
        int l = hotkeys.length;
        if (l != hotkeycodes.length) {
            logger.println(T._("Console: WARNING: hotkey definition mismatch, some buttons will be ignored"));
            l = Math.min(hotkeys.length, hotkeycodes.length);
        }
        for (int i = 0; i < l; ++i) {
            try {
                if (hotkeycodes[i] == null || hotkeycodes[i].length() == 0) continue;
                JButton b = hotkeycodes[i].startsWith("kvm") ? new KvmPortButton(hotkeys[i], hotkeycodes[i]) : new HotKeyButton(hotkeys[i], hotkeycodes[i], hotkeynames[i]);
                this.add(b);
                this.buttons.addElement(b);
                continue;
            }
            catch (ParseException e) {
                logger.println(T._("Console: hotkey error:") + " " + e);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] comp = this.getComponents();
        if (comp.length == 0) {
            return new Dimension(0, 0);
        }
        int bh = comp[0].getPreferredSize().height;
        int h = 1;
        int w = 0;
        for (int i = 0; i < comp.length; ++i) {
            int bw = comp[i].getPreferredSize().width;
            if ((w += bw) <= this.preferred_width) continue;
            this.use_preferred_width = true;
            w = bw;
            ++h;
        }
        int cw = this.use_preferred_width ? this.preferred_width : w;
        return new Dimension(cw, h * (bh + 1));
    }

    public void setPreferredWidth(int w) {
        this.preferred_width = w;
        if (this.use_preferred_width) {
            this.setSize(w, this.getSize().height);
        }
    }

    @Override
    public void setEnabled(boolean switchOn) {
        Enumeration e = this.buttons.elements();
        while (e.hasMoreElements()) {
            JButton b = (JButton)e.nextElement();
            b.setEnabled(switchOn);
        }
    }

    public void setMonitorMode(boolean moni) {
        this.monimode = moni;
    }

    public static void main(String[] args) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(null);
        try {
            String s = (String)content.getTransferData(DataFlavor.stringFlavor);
            System.out.println(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class KvmPortButton
    extends JButton
    implements ActionListener {
        short portno;

        public KvmPortButton(String hotkey, String code) throws ParseException {
            super(hotkey);
            StringTokenizer st = new StringTokenizer(code);
            try {
                st.nextToken();
                this.portno = Short.parseShort(st.nextToken(), 10);
            }
            catch (Exception e) {
                throw new ParseException(code, 0);
            }
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            ButtonPanel.this.frame.console.switchKvmPort(this.portno);
        }
    }

    class ClipBoardButton
    extends JButton
    implements ActionListener {
        private static final String CONFIRM = "confirm";
        private boolean confirm;
        private Vector codes;

        public ClipBoardButton(String hotkey, String codes, String name) {
            this.setButtonKey(hotkey, codes, name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            if (ButtonPanel.this.monimode) {
                return;
            }
            Stack<Short> relkeys = new Stack<Short>();
            this.codes = this.getStringFromClibBoard();
            block7: for (int i = 0; i < this.codes.size(); ++i) {
                Short keynr = (Short)this.codes.elementAt(i);
                short k = keynr;
                switch (k) {
                    case 242: {
                        try {
                            Thread.sleep(ButtonPanel.this.keypause);
                        }
                        catch (Exception exception) {}
                        continue block7;
                    }
                    case 241: {
                        this.releaseStackKeys(relkeys);
                    }
                    case 240: {
                        continue block7;
                    }
                    default: {
                        relkeys.push(keynr);
                        ButtonPanel.this.keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
                    }
                }
            }
            this.releaseStackKeys(relkeys);
        }

        private void releaseStackKeys(Stack keys) {
            try {
                while (true) {
                    Short keynr = (Short)keys.pop();
                    ButtonPanel.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
                }
            }
            catch (EmptyStackException emptyStackException) {
                return;
            }
        }

        private void setButtonKey(String text, String kcodes, String name) {
            String keyText = text.trim();
            this.confirm = false;
            if (keyText.startsWith(CONFIRM)) {
                this.confirm = true;
                keyText = keyText.substring(CONFIRM.length());
                keyText = keyText.trim();
            }
            if (name != null && name.length() > 0) {
                this.setLabel(name);
            } else {
                this.setLabel(keyText);
            }
        }

        public Vector getStringFromClibBoard() {
            String s = null;
            Vector<Short> v = new Vector<Short>();
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = cb.getContents(null);
            try {
                s = (String)content.getTransferData(DataFlavor.stringFlavor);
                System.out.println(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            byte[] ss = s.getBytes();
            for (int i = 0; i < ss.length; ++i) {
                int j;
                for (j = 0; j < KeyTranslator.codetable.length; ++j) {
                    if (KeyTranslator.codetable[j][0] != ss[i]) continue;
                    v.add(new Short((short)KeyTranslator.codetable[j][1]));
                    break;
                }
                if (j != KeyTranslator.codetable.length - 1) continue;
                v.add(new Short(ss[i]));
            }
            return v;
        }
    }

    class HotKeyButton
    extends JButton
    implements ActionListener {
        private static final String CONFIRM = "confirm";
        private boolean confirm;
        private Vector codes;

        public HotKeyButton(String hotkey, String codes, String name) throws ParseException {
            this.setButtonKey(hotkey, codes, name);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            ButtonPanel.this.frame.handleFocus((Component)ev.getSource());
            if (ButtonPanel.this.monimode) {
                return;
            }
            if (this.confirm) {
                ConfirmDialog d = new ConfirmDialog(MessageFormat.format(T._("Do you really want to send \"{0}\"?"), this.getLabel()), T._("Confirmation"), 1, true);
                int x = (Toolkit.getDefaultToolkit().getScreenSize().width - d.getWidth()) / 2;
                int y = (Toolkit.getDefaultToolkit().getScreenSize().height - d.getHeight()) / 2;
                Point p = new Point(x, y);
                d.setLocation(p);
                d.show();
                boolean ok = d.ok;
                d.dispose();
                d = null;
                if (!ok) {
                    return;
                }
            }
            Stack<Short> relkeys = new Stack<Short>();
            block7: for (int i = 0; i < this.codes.size(); ++i) {
                Short keynr = (Short)this.codes.elementAt(i);
                short k = keynr;
                switch (k) {
                    case 242: {
                        try {
                            Thread.sleep(ButtonPanel.this.keypause);
                        }
                        catch (Exception exception) {}
                        continue block7;
                    }
                    case 241: {
                        this.releaseStackKeys(relkeys);
                    }
                    case 240: {
                        continue block7;
                    }
                    default: {
                        relkeys.push(keynr);
                        ButtonPanel.this.keh.internalPressed(keynr, KeyEventHandler.KEYBOARD);
                    }
                }
            }
            this.releaseStackKeys(relkeys);
        }

        private void releaseStackKeys(Stack keys) {
            try {
                while (true) {
                    Short keynr = (Short)keys.pop();
                    ButtonPanel.this.keh.released(keynr, KeyEventHandler.KEYBOARD);
                }
            }
            catch (EmptyStackException emptyStackException) {
                return;
            }
        }

        private void setButtonKey(String text, String kcodes, String name) throws ParseException {
            if (text == null || text.length() == 0) {
                throw new ParseException(text, 0);
            }
            String keyText = text.trim();
            this.confirm = false;
            if (keyText.startsWith(CONFIRM)) {
                this.confirm = true;
                keyText = keyText.substring(CONFIRM.length());
                keyText = keyText.trim();
            }
            if (name != null && name.length() > 0) {
                this.setLabel(name);
            } else {
                this.setLabel(keyText);
            }
            this.codes = new Vector();
            StringTokenizer st = new StringTokenizer(kcodes);
            while (st.hasMoreTokens()) {
                try {
                    int c = Integer.parseInt(st.nextToken(), 16);
                    this.codes.addElement(new Short((short)c));
                }
                catch (NumberFormatException e) {
                    throw new ParseException(kcodes, 0);
                }
            }
        }
    }
}

