/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.summary;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.Common;
import com.supermicro.ipmi.nm.sensor.CUPSSensor;
import com.supermicro.ipmi.nm.sensor.SensorDefine;

public class NMCUPSUtil {
    private IPMINM20Command ipmiCommand;

    public NMCUPSUtil(IPMINM20Command ipmiCommand) {
        this.ipmiCommand = ipmiCommand;
    }

    public CUPS getCUPS() throws IPMIException {
        int core = this.getCUPSSensor(190);
        int io = this.getCUPSSensor(191);
        int mem = this.getCUPSSensor(192);
        return new CUPS(core, mem, io);
    }

    private int getCUPSSensor(int sensorId) throws IPMIException {
        SensorDefine s = Common.SENSOR_DEFINES.get(sensorId);
        IPMIMessage resMessage = this.ipmiCommand.getSensorReadingCommand((byte)sensorId);
        if (resMessage != null && resMessage.completionCode == 0) {
            return new CUPSSensor(s, resMessage.data, null).getReading();
        }
        throw new IPMIException();
    }

    public class CUPS {
        public final int core;
        public final int mem;
        public final int io;

        public CUPS(int core, int mem, int io) {
            this.core = core;
            this.mem = mem;
            this.io = io;
        }
    }
}

