/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserAddCommand
extends SuperBladeCommand {
    byte userID;
    String username;
    String password;
    byte privilege;

    @Override
    public boolean preValidate() {
        if (this.config.getPrivilege() != 4) {
            MOut.G(this).println("Your privilege is not enough to do this action");
            return false;
        }
        String usage = "Usage: user add <user id> <user name> <password> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nNo Access           : 15\n";
        if (this.parameters == null || this.parameters.length != 4) {
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
            if (this.userID < 1 || this.userID > 10) {
                MOut.G(this).println("user id should be 1-10");
                MOut.G(this).println(usage);
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("user id should be 1-10");
            MOut.G(this).println(usage);
            return false;
        }
        this.username = this.parameters[1];
        if (this.username.length() > 15) {
            MOut.G(this).println("username should less then 15 characters");
            MOut.G(this).println(usage);
            return false;
        }
        this.password = this.parameters[2];
        if (this.password.length() > 19) {
            MOut.G(this).println("password should less then 19 characters");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[3]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("privilege should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if ((this.privilege < 2 || this.privilege > 4) && this.privilege != 15) {
            MOut.G(this).println("Privilege level error");
            MOut.G(this).println("Administrator level : 4");
            MOut.G(this).println("Operator level      : 3");
            MOut.G(this).println("User level          : 2");
            MOut.G(this).println("No access           : 15");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int numberOfUsers = ipmiMessagingCommand.getNumberOfAvailableUser();
        for (int i = 2; i < numberOfUsers + 1; ++i) {
            String name = ipmiMessagingCommand.getUserNameByID((byte)i);
            if (name == null || name.length() == 0 || !name.equals(this.username)) continue;
            MOut.G(this).println("This user name has been used, please change to another one.");
            this.statusCode = 147;
            return;
        }
        boolean b1 = ipmiMessagingCommand.setUserNameByID(this.userID, this.username);
        if (!b1) {
            MOut.G(this).println("Set user name failed");
            this.statusCode = 149;
            return;
        }
        boolean b2 = ipmiMessagingCommand.setUserPasswordByID(this.userID, this.password);
        if (!b2) {
            MOut.G(this).println("Set user password failed");
            this.statusCode = 149;
            return;
        }
        boolean b3 = ipmiMessagingCommand.setEnableUserByID(this.userID);
        if (!b3) {
            MOut.G(this).println("Set enable user failed");
            this.statusCode = 149;
            return;
        }
        boolean b4 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, this.privilege);
        if (!b4) {
            MOut.G(this).println("Set user privilege failed");
            this.statusCode = 149;
            return;
        }
        boolean b5 = ipmiMessagingCommand.setEnableUserPlusByID(this.userID, this.privilege);
        if (!b5) {
            MOut.G(this).println("Set enable user(+) failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

