/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMINVMECommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class NVMEFWUpdateCommand
extends SuperBladeCommand {
    byte aoc;
    byte slot;
    byte group;
    byte controller = (byte)35;

    @Override
    public boolean preValidate() {
        this.aoc = 0;
        this.slot = 0;
        this.group = 0;
        if (this.parameters == null || this.parameters.length < 5) {
            MOut.G(this).println("Usage: nvme fwupdate <aoc> <group> <slot> <controller> <fileName>");
            return false;
        }
        try {
            this.aoc = Byte.parseByte(this.parameters[0], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        try {
            this.group = Byte.parseByte(this.parameters[1], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        try {
            this.slot = Byte.parseByte(this.parameters[2], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        try {
            this.controller = Byte.parseByte(this.parameters[3], 10);
        }
        catch (NumberFormatException e) {
            MOut.G(this).println(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        long start;
        boolean commitDisable = false;
        if (this.parameters.length > 5) {
            for (int i = 5; i < this.parameters.length; ++i) {
                if (!this.parameters[i].toLowerCase().contains("-commitdisable")) continue;
                commitDisable = true;
            }
        }
        IPMINVMECommand ipmiNVMECommand = new IPMINVMECommand(null);
        ipmiNVMECommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (!ipmiNVMECommand.setFWUploadArgument(this.aoc, this.group, this.slot, this.controller)) {
            MOut.G(this).println("Set FW update argument failed");
            return;
        }
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte currentProgress = 0;
        byte lastProgress = 0;
        long firstStart = System.currentTimeMillis();
        ipmiNVMECommand.setFWUploadArgument(this.aoc, this.group, this.slot, this.controller);
        boolean result = ipmiBMCFileCommand.generalFileUpload((byte)18, this.parameters[4]);
        if (result) {
            MOut.G(this).println("");
            MOut.G(this).println("");
            MOut.G(this).println("====================================");
            MOut.G(this).println("Updating");
            MOut.G(this).println("====================================");
            MOut.G(this).print("Progress:|");
            start = System.currentTimeMillis();
            while (true) {
                Thread.sleep(20000L);
                currentProgress = ipmiNVMECommand.getFWUploadStatus();
                if (currentProgress > 100) {
                    this.statusCode = 149;
                    MOut.G(this).println("Update failed. Error code = 0x" + ByteUtility.byteToHex(currentProgress));
                    return;
                }
                if (currentProgress != 100) {
                    if (currentProgress <= lastProgress) continue;
                    if (currentProgress % 2 == 0) {
                        MOut.G(this).print(">");
                    }
                    lastProgress = currentProgress;
                    continue;
                }
                break;
            }
        } else {
            this.statusCode = 149;
            MOut.G(this).println("Upload FW file failed");
            return;
        }
        MOut.G(this).println("| 100%");
        MOut.G(this).println("Done");
        this.printTimeString("Update time", System.currentTimeMillis() - start);
        if (!commitDisable) {
            MOut.G(this).println("Commiting...");
            ipmiNVMECommand.commitFWUpdate(this.aoc, this.group, this.slot, this.controller);
        }
        this.printTimeString("Total elapsed time", System.currentTimeMillis() - firstStart);
        this.statusCode = 0;
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        MOut.G(this).println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }
}

