/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.GetNodeManagerPolicyAlertThresholds;
import com.supermicro.ipmi.nm.GetNodeManagerPolicySuspendPeriods;
import com.supermicro.ipmi.nm.PolicyAlertThresholds;
import com.supermicro.ipmi.nm.PolicySuspendPeriods;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import com.supermicro.ipmi.text.NM20GetPolicyCommand;

public class NM20ScanPolicyCommand
extends NM20AbstractCommand {
    @Override
    public void runNM20Command() throws Exception {
        int totalPoliciesCount = 0;
        IPMINM20Command.NodeManagerPolicy policy = null;
        GetNodeManagerPolicySuspendPeriods getSuspendPeriods = new GetNodeManagerPolicySuspendPeriods(this.ipmiNM20Command);
        GetNodeManagerPolicyAlertThresholds getAlertThresholds = new GetNodeManagerPolicyAlertThresholds(this.ipmiNM20Command);
        byte[] domainIDs = new byte[]{0, 1, 2, 4};
        block2: for (int i = 0; i < domainIDs.length; ++i) {
            byte pid = 0;
            byte policyCount = 0;
            while (true) {
                try {
                    while (true) {
                        policy = this.ipmiNM20Command.getNodeManagerPolicy(domainIDs[i], pid);
                        MOut.G(this).println("=============================================");
                        MOut.G(this).println("Domain ID = " + (domainIDs[i] & 0xFF) + " , Policy ID = " + (pid & 0xFF));
                        MOut.G(this).println("=============================================");
                        NM20GetPolicyCommand.printPolicy(policy, MOut.G(this));
                        MOut.G(this).println("\nAlert Thresholds:");
                        PolicyAlertThresholds thresholds = getAlertThresholds.execute(domainIDs[i], pid);
                        thresholds.toReadableString();
                        MOut.G(this).println("\nSuspend Periods:");
                        PolicySuspendPeriods periods = getSuspendPeriods.execute(domainIDs[i], pid);
                        periods.toReadableString();
                        policyCount = (byte)(policyCount + 1);
                        ++totalPoliciesCount;
                        if ((pid & 0xFF) == 255) continue block2;
                        pid = (byte)(pid + 1);
                    }
                }
                catch (IPMIException ex) {
                    if ((pid & 0xFF) == 255) continue block2;
                    IPMIMessage ipmiMessage = ex.getIPMIMessage();
                    if (ipmiMessage.completionCode != -128) continue block2;
                    byte nextValidPid = ex.getIPMIMessage().data[3];
                    byte NoOfPolicy = ex.getIPMIMessage().data[4];
                    if (policyCount == NoOfPolicy) continue block2;
                    pid = nextValidPid;
                    continue;
                }
                break;
            }
        }
        MOut.G(this).println("");
        MOut.G(this).println("Total Policies = " + totalPoliciesCount);
        this.statusCode = 0;
    }
}

