/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.SwitchInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeSwitchCommand
extends MicroBladeCommand {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() != null) {
            if (this.getParameters().length != 1) {
                MOut.G(this).println("[switch index] is required");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            String switchIndex = this.getParameters()[0];
            byte sIndex = (byte)SwitchInfo.getIndex(switchIndex);
            if (sIndex < 0) {
                MOut.G(this).println("The switch index must be A1-A2 or B1-B2");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch(sIndex, (byte)1);
            if (!switchInfo.isPresent()) {
                MOut.G(this).println("Switch " + switchIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            MOut.G(this).print(switchInfo.toFormatedHeader());
            MOut.G(this).println(switchInfo.toFormatedString());
        } else {
            for (int i = 0; i < 4; ++i) {
                SwitchInfo switchInfo = ipmiMicroBladeOEMCommand.getSwitch((byte)i, (byte)1);
                if (switchInfo.isPresent()) {
                    MOut.G(this).print(switchInfo.toFormatedHeader());
                    MOut.G(this).println(switchInfo.toFormatedString());
                    continue;
                }
                MOut.G(this).println("Switch " + SwitchInfo.getIndex(i) + " is not presented");
            }
        }
        sessionController.closeSession();
        this.statusCode = 0;
    }
}

