/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.microblade.BladeRemoteInfo;
import com.supermicro.ipmi.microblade.NodeSensorInfo;
import com.supermicro.ipmi.microblade.NodeStatusInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MicroBladeCommand;

public class MicroBladeNodeStatusCommand
extends MicroBladeCommand {
    @Override
    public void execute() throws Exception {
        if (!this.validateForCMM()) {
            this.statusCode = 153;
            return;
        }
        int nodeIndex = 0;
        IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiMicroBladeOEMCommand);
        if (sessionController == null) {
            this.statusCode = 145;
            return;
        }
        if (this.getParameters() == null) {
            MOut.G(this).println("\nUsage: microbBlade node power <bladeID> <nodeID> [options]");
            MOut.G(this).println("For power status options:");
            MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
        } else if (this.getParameters().length == 2) {
            String bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            byte status = ipmiMicroBladeOEMCommand.getNodeStatus((int)bIndex, nodeIndex - 1);
            MOut.G(this).println("For power status options:");
            MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
            if (status == 0) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " current power off");
            } else if (status == 1) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " current power on");
            }
        } else if (this.getParameters().length == 3) {
            String bladeIndex = this.getParameters()[0];
            nodeIndex = Integer.parseInt(this.getParameters()[1]);
            int powerIndex = Integer.parseInt(this.getParameters()[2]);
            byte bIndex = (byte)NodeSensorInfo.getBladeIndex(bladeIndex);
            if (bIndex < 0) {
                MOut.G(this).println("The blade index must be A1-A14 or B1-B14");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            if (nodeIndex < 1 || nodeIndex > 4) {
                MOut.G(this).println("The node index must be 1-4");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            BladeRemoteInfo bladeRemoteInfo = ipmiMicroBladeOEMCommand.getBladeRemoteInfo(bIndex);
            NodeStatusInfo nodeStatusInfo = ipmiMicroBladeOEMCommand.getNodeStatus(bIndex, (byte)(nodeIndex - 1));
            if (!nodeStatusInfo.initialized() || !bladeRemoteInfo.isPresent()) {
                MOut.G(this).println("Blade " + bladeIndex + " Node " + nodeIndex + " is not presented");
                this.statusCode = 151;
                sessionController.closeSession();
                return;
            }
            if (powerIndex < 0 || powerIndex > 5) {
                MOut.G(this).println("The power index must be 0,1,2,3,4 or 5");
                MOut.G(this).println("For power status options");
                MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
                this.statusCode = 147;
                sessionController.closeSession();
                return;
            }
            if (powerIndex == 4) {
                powerIndex = 24;
            }
            ipmiMicroBladeOEMCommand.setNodeStatus(bIndex, --nodeIndex, powerIndex);
            MOut.G(this).println("done");
        } else {
            MOut.G(this).println("\nUsage: microbBlade node power <bladeID> <nodeID> [options]");
            MOut.G(this).println("For power status options:");
            MOut.G(this).println("Power Off: 0 \nPower On:1 \nPower cycle:2 \nPower Reset:3 \nAC cycle:4 \nGraceful-shutdown:5");
        }
        sessionController.closeSession();
        this.statusCode = 0;
    }
}

