/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.ipmi.lic.SWLicenseAdapter;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public abstract class IPMIX10OEMWebSettingAbstractCommand
extends SuperBladeCommand {
    public boolean isX10CFGSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid != null && IPMIMessagingCommand.isATENAspeedGUID(guid) || guid != null && IPMIMessagingCommand.isCB3GUID(guid) || guid != null && IPMIMessagingCommand.isMicroBladeNodeGUID(guid) || guid != null && IPMIMessagingCommand.isATENSuperBladeGUID(guid) || guid != null && IPMIMessagingCommand.isAST2400GUID(guid) || guid != null && IPMIMessagingCommand.isAST2500GUID(guid) || guid != null && IPMIMessagingCommand.isP8DTUGUID(guid) || guid != null && IPMIMessagingCommand.isPOWER9GUID(guid) || guid != null && IPMIMessagingCommand.is8USuperBladeGUID(guid) || guid != null && IPMIMessagingCommand.isAST2500HW1GUID(guid) || guid != null && IPMIMessagingCommand.isH11GUID(guid) || guid != null && IPMIMessagingCommand.isH12GUID(guid)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean checkIfSWProductKeyNotActivated() {
        this.closeSessionIfExist();
        boolean isPassSWKey = false;
        try {
            if (SWLicenseAdapter.isSWFRUSupported(this.config)) {
                if (SWLicenseAdapter.check_SFT_SUM_LIC_ProductKey(this.config)) {
                    isPassSWKey = true;
                }
            } else {
                MOut.G(this).println("This device is not supported ");
                this.statusCode = 153;
            }
        }
        catch (SWKeyExpiredException e) {
            MOut.G(this).println("Node product key is expired");
            this.statusCode = 155;
            return true;
        }
        catch (Exception e) {
            this.statusCode = 149;
        }
        this.createSession();
        if (!isPassSWKey && super.checkIfSWProductKeyNotActivated()) {
            MOut.G(this).println("The node product key needs to be activated for this device");
            this.statusCode = 153;
            return true;
        }
        return false;
    }
}

