/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.util.StringTokenizer;

public class IPMIOEMDDNSServerCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    public static final byte DDNSState = 0;
    public static final byte TSIGState = 1;
    public static final byte DNSServerIP = 2;
    public static final byte HostName = 3;
    private static final byte NTPSetting = 0;

    @Override
    public boolean preValidate() {
        if (this.parameters != null && !IPMILanCommand.isIPAddress(this.parameters[0])) {
            MOut.G(this).println("IP format error!");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] ddnsData = ipmiOEMWebSettingCommand.getDDNS((byte)0);
        if (ddnsData[0] == 0) {
            MOut.G(this).println("Dynamic Update State is Disable");
        } else if (this.parameters == null) {
            MOut.G(this).println(new String(ipmiOEMWebSettingCommand.getDDNS((byte)2)));
        } else {
            byte[] ntpData = ipmiOEMWebSettingCommand.getNTPDateTime((byte)0);
            if (ntpData[0] == 0) {
                MOut.G(this).println("You should synchronize system time with NTP first.");
                this.statusCode = 0;
                return;
            }
            byte[] tsigData = ipmiOEMWebSettingCommand.getDDNS((byte)1);
            byte[] hostName = ipmiOEMWebSettingCommand.getDDNS((byte)3);
            byte[] values = new byte[5 + hostName.length + 1];
            values[0] = tsigData[0];
            StringTokenizer st = new StringTokenizer(this.parameters[0], ".");
            for (int i = 0; i < 4; ++i) {
                values[i + 1] = (byte)Integer.parseInt(st.nextToken());
            }
            System.arraycopy(hostName, 0, values, 5, hostName.length);
            ipmiOEMWebSettingCommand.setDDNS(ddnsData[0], values);
            MOut.G(this).println("Done");
        }
        this.statusCode = 0;
    }
}

