/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIMicroBladeOEMCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.microblade.PowerSupplyInfo;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class AllPowerSupplyStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isMicroBladeCMMGUID(guid)) {
            IPMIMicroBladeOEMCommand ipmiMicroBladeOEMCommand = new IPMIMicroBladeOEMCommand(null);
            ipmiMicroBladeOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
            int powerCount = 0;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 8; ++i) {
                PowerSupplyInfo powerSupplyInfo = ipmiMicroBladeOEMCommand.getPowerSupply((byte)i, (byte)1);
                if (!powerSupplyInfo.isPresent()) continue;
                ++powerCount;
                sb.append(powerSupplyInfo.to7UFormatedString());
            }
            MOut.G(this).print("Power Supply Module (" + powerCount + "/" + 8 + ")\n");
            MOut.G(this).print("--------------------------\n");
            MOut.G(this).print(ipmiMicroBladeOEMCommand.getPowerSupply((byte)0, (byte)1).to7UFormatedHeader());
            MOut.G(this).print(sb.toString());
            this.statusCode = 0;
            return;
        }
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryPowerSupplyEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.G(this).println("Login error!");
            this.statusCode = 146;
            return;
        }
        MOut.G(this).println(bladeSystem.toPowerSupplyFormatedString());
        this.statusCode = 0;
    }
}

