/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.nm.sensor;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.nm.sensor.SensorDefine;
import com.supermicro.ipmi.nm.sensor.SensorReading;

public abstract class Sensor {
    protected final SensorReading sr;
    protected final SensorDefine sd;

    public Sensor(SensorDefine sd, byte[] readingData) {
        this.sr = new SensorReading(readingData);
        this.sd = sd;
    }

    public STATUS getStatus() {
        if (!this.sr.isAvailable()) {
            return STATUS.UNAVAILABLE;
        }
        return STATUS.NORMAL;
    }

    public int getId() {
        return this.sd.getId();
    }

    public String getName() {
        return this.sd.getName();
    }

    public String getUnit() {
        return this.sd.getUnit();
    }

    public int getReading() {
        return this.sr.getReading();
    }

    public String getReadingDataString() {
        if (this.sr.getRaw() != null) {
            return ByteUtility.bytesToHex(this.sr.getRaw());
        }
        return null;
    }

    public static enum STATUS {
        NORMAL,
        NOT_SCANNING,
        UNAVAILABLE;

    }
}

