/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_B9QR7_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String CPU3 = "CPU3 Temp";
    public static final String CPU4 = "CPU4 Temp";
    public static final String SYSTEM_TEMP_1 = "System";
    public static final String SYSTEM_TEMP_2 = "Peripheral";
    public static final String CPU3_VOLTAGE = "CPU3 Vcore";
    public static final String CPU4_VOLTAGE = "CPU4 Vcore";
    public static final String V1P1 = "1.1V";
    public static final String DIMM_1_VOLTAGE = "DIMM ABCD voltage";
    public static final String DIMM_2_VOLTAGE = "DIMM EFGH voltage";
    public static final String DIMM_3_VOLTAGE = "DIMM IJKL voltage";
    public static final String DIMM_4_VOLTAGE = "DIMM MNOP voltage";
    public static final String V3P3SB = "3.3VSB";
    public static final String PCH_TEMP = "PCH Temp";
    public static final String DIMM_A1_Temp = "DIMM A1 Temp";
    public static final String DIMM_B1_Temp = "DIMM B1 Temp";
    public static final String DIMM_C1_Temp = "DIMM C1 Temp";
    public static final String DIMM_D1_Temp = "DIMM D1 Temp";
    public static final String DIMM_E1_Temp = "DIMM E1 Temp";
    public static final String DIMM_F1_Temp = "DIMM F1 Temp";
    public static final String DIMM_G1_Temp = "DIMM G1 Temp";
    public static final String DIMM_H1_Temp = "DIMM H1 Temp";
    public static final String DIMM_I1_Temp = "DIMM I1 Temp";
    public static final String DIMM_J1_Temp = "DIMM J1 Temp";
    public static final String DIMM_K1_Temp = "DIMM K1 Temp";
    public static final String DIMM_L1_Temp = "DIMM L1 Temp";
    public static final String DIMM_M1_Temp = "DIMM M1 Temp";
    public static final String DIMM_N1_Temp = "DIMM N1 Temp";
    public static final String DIMM_O1_Temp = "DIMM O1 Temp";
    public static final String DIMM_P1_Temp = "DIMM P1 Temp";
    public static final String CurrPwr = "Power Consumption";
    private byte cpu3CoreVoltage;
    private byte cpu4CoreVoltage;
    private byte system2Temp;
    private byte vDIMM1Voltage;
    private byte vDIMM2Voltage;
    private byte vDIMM3Voltage;
    private byte vDIMM4Voltage;
    private byte v3p3sb;
    private byte pchTemp;
    private byte dimmA1Temp;
    private byte dimmB1Temp;
    private byte dimmC1Temp;
    private byte dimmD1Temp;
    private byte dimmE1Temp;
    private byte dimmF1Temp;
    private byte dimmG1Temp;
    private byte dimmH1Temp;
    private byte dimmI1Temp;
    private byte dimmJ1Temp;
    private byte dimmK1Temp;
    private byte dimmL1Temp;
    private byte dimmM1Temp;
    private byte dimmN1Temp;
    private byte dimmO1Temp;
    private byte dimmP1Temp;
    private byte cpu1TempLimit;
    private byte cpu2TempLimit;
    private byte cpu3TempLimit;
    private byte cpu4TempLimit;
    private byte pwr;
    private byte staticPCHTempHighLimit = (byte)95;
    private byte staticSystemTempHighLimit = (byte)85;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.cpu1CoreVoltage = raw[2];
        this.cpu2CoreVoltage = raw[3];
        this.cpu3CoreVoltage = raw[4];
        this.cpu4CoreVoltage = raw[5];
        this.vDIMM1Voltage = raw[6];
        this.vDIMM2Voltage = raw[7];
        this.vDIMM3Voltage = raw[8];
        this.vDIMM4Voltage = raw[9];
        this.v1p2 = raw[10];
        this.v3p3 = raw[11];
        this.v3p3sb = raw[12];
        this.v5 = raw[13];
        this.v5sb = raw[14];
        this.v12 = raw[15];
        this.batteryVoltage = raw[16];
        this.remoteCPU1Temp = raw[18];
        this.remoteCPU2Temp = raw[19];
        this.remoteCPU3Temp = raw[20];
        this.remoteCPU4Temp = raw[21];
        this.systemTemp = raw[22];
        this.system2Temp = raw[23];
        this.pchTemp = raw[24];
        this.dimmA1Temp = raw[38];
        this.dimmB1Temp = raw[39];
        this.dimmC1Temp = raw[40];
        this.dimmD1Temp = raw[41];
        this.dimmE1Temp = raw[42];
        this.dimmF1Temp = raw[43];
        this.dimmG1Temp = raw[44];
        this.dimmH1Temp = raw[45];
        this.dimmI1Temp = raw[46];
        this.dimmJ1Temp = raw[47];
        this.dimmK1Temp = raw[48];
        this.dimmL1Temp = raw[49];
        this.dimmM1Temp = raw[50];
        this.dimmN1Temp = raw[51];
        this.dimmO1Temp = raw[52];
        this.dimmP1Temp = raw[53];
        this.cpu1TempLimit = raw[54];
        this.cpu2TempLimit = raw[55];
        this.cpu3TempLimit = raw[56];
        this.cpu4TempLimit = raw[57];
        this.pwr = raw[58];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkRemoteCPU3Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU3));
        }
        if (this.checkRemoteCPU4Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU4));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_1));
        }
        if (this.checkSystemTemp2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, SYSTEM_TEMP_2));
        }
        if (this.checkPCHTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, PCH_TEMP));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkCpu3CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU3_VOLTAGE));
        }
        if (this.checkCpu4CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU4_VOLTAGE));
        }
        if (this.checkVDIMM1Voltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_1_VOLTAGE));
        }
        if (this.checkVDIMM2Voltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_2_VOLTAGE));
        }
        if (this.checkVDIMM3Voltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_3_VOLTAGE));
        }
        if (this.checkVDIMM4Voltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_4_VOLTAGE));
        }
        if (this.checkp1v2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU VTT"));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV3p3sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V3P3SB));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        if (this.checkPower() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CurrPwr));
        }
        if (this.checkDIMMTemp(this.dimmA1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_A1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmB1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_B1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmC1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_C1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmD1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_D1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmE1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_E1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmF1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_F1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmG1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_G1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmH1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_H1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmI1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_I1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmJ1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_J1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmK1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_K1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmL1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_L1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmM1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_M1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmN1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_N1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmO1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_O1_Temp));
        }
        if (this.checkDIMMTemp(this.dimmP1Temp) == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, DIMM_P1_Temp));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getCpu1TempLimit()));
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getCpu2TempLimit()));
        this.addRaw(this.checkRemoteCPU3Temp(), CPU3, this.showCandF(this.getRemoteCPU3Temp()), "N/A", "" + this.showCandF(this.getCpu3TempLimit()));
        this.addRaw(this.checkRemoteCPU4Temp(), CPU4, this.showCandF(this.getRemoteCPU4Temp()), "N/A", "" + this.showCandF(this.getCpu4TempLimit()));
        this.addRaw(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        this.addRaw(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        this.addRaw(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.staticPCHTempHighLimit));
        this.addRaw(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_Temp, this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_Temp, this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_Temp, this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_Temp, this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_Temp, this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_Temp, this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_Temp, this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_Temp, this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmI1Temp), DIMM_I1_Temp, this.showCandF(this.dimmI1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmJ1Temp), DIMM_J1_Temp, this.showCandF(this.dimmJ1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmK1Temp), DIMM_K1_Temp, this.showCandF(this.dimmK1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmL1Temp), DIMM_L1_Temp, this.showCandF(this.dimmL1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmM1Temp), DIMM_M1_Temp, this.showCandF(this.dimmM1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmN1Temp), DIMM_N1_Temp, this.showCandF(this.dimmN1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmO1Temp), DIMM_O1_Temp, this.showCandF(this.dimmO1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkDIMMTemp(this.dimmP1Temp), DIMM_P1_Temp, this.showCandF(this.dimmP1Temp), "N/A", "" + this.showCandF((byte)85));
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpuCoreVoltageLowLimit()), this.d2StrV(this.getCpuCoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpuCoreVoltageLowLimit()), this.d2StrV(this.getCpuCoreVoltageHighLimit()));
        this.addRaw(this.checkCpu3CoreVoltage(), CPU3_VOLTAGE, this.d2StrV(this.getCpu3CoreVoltageFormula()), this.d2StrV(this.getCpuCoreVoltageLowLimit()), this.d2StrV(this.getCpuCoreVoltageHighLimit()));
        this.addRaw(this.checkCpu4CoreVoltage(), CPU4_VOLTAGE, this.d2StrV(this.getCpu4CoreVoltageFormula()), this.d2StrV(this.getCpuCoreVoltageLowLimit()), this.d2StrV(this.getCpuCoreVoltageHighLimit()));
        this.addRaw(this.checkVDIMM1Voltage(), DIMM_1_VOLTAGE, this.d2StrV(this.getVDIMM1VoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMM2Voltage(), DIMM_2_VOLTAGE, this.d2StrV(this.getVDIMM2VoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMM3Voltage(), DIMM_3_VOLTAGE, this.d2StrV(this.getVDIMM3VoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkVDIMM4Voltage(), DIMM_4_VOLTAGE, this.d2StrV(this.getVDIMM4VoltageFormula()), this.d2StrV(this.getDIMMVoltageLowLimit()), this.d2StrV(this.getDIMMVoltageHighLimit()));
        this.addRaw(this.checkV1p2(), "CPU VTT", this.d2StrV(this.getV1p2Formula()), this.d2StrV(this.getV1p2LowLimit()), this.d2StrV(this.getV1p2HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV3p3sb(), V3P3SB, this.d2StrV(this.getV3p3sbFormula()), this.d2StrV(this.getV3p3sbLowLimit()), this.d2StrV(this.getV3p3sbHighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        this.addRaw(this.checkPower(), CurrPwr, this.d2StrV(this.getPwr()), "0", "" + this.getPowerHighLimit());
        return this.formatedString.toString();
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCandF(this.getRemoteCPU1Temp()), "N/A", "" + this.showCandF(this.getCpu1TempLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCandF(this.getRemoteCPU2Temp()), "N/A", "" + this.showCandF(this.getCpu2TempLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU3Temp(), CPU3, this.showCandF(this.getRemoteCPU3Temp()), "N/A", "" + this.showCandF(this.getCpu3TempLimit())));
        list.add(this.createTemperatureData(this.checkRemoteCPU4Temp(), CPU4, this.showCandF(this.getRemoteCPU4Temp()), "N/A", "" + this.showCandF(this.getCpu4TempLimit())));
        list.add(this.createTemperatureData(this.checkPCHTemp(), PCH_TEMP, this.showCandF(this.pchTemp), "N/A", "" + this.showCandF(this.getPCHTempHighLimit())));
        list.add(this.createTemperatureData(this.checkSystemTemp(), SYSTEM_TEMP_1, this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        list.add(this.createTemperatureData(this.checkSystemTemp2(), SYSTEM_TEMP_2, this.showCandF(this.system2Temp), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmA1Temp), DIMM_A1_Temp, this.showCandF(this.dimmA1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmB1Temp), DIMM_B1_Temp, this.showCandF(this.dimmB1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmC1Temp), DIMM_C1_Temp, this.showCandF(this.dimmC1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmD1Temp), DIMM_D1_Temp, this.showCandF(this.dimmD1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmE1Temp), DIMM_E1_Temp, this.showCandF(this.dimmE1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmF1Temp), DIMM_F1_Temp, this.showCandF(this.dimmF1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmG1Temp), DIMM_G1_Temp, this.showCandF(this.dimmG1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmH1Temp), DIMM_H1_Temp, this.showCandF(this.dimmH1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmI1Temp), DIMM_I1_Temp, this.showCandF(this.dimmI1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmJ1Temp), DIMM_J1_Temp, this.showCandF(this.dimmJ1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmK1Temp), DIMM_K1_Temp, this.showCandF(this.dimmK1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmL1Temp), DIMM_L1_Temp, this.showCandF(this.dimmL1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmM1Temp), DIMM_M1_Temp, this.showCandF(this.dimmM1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmN1Temp), DIMM_N1_Temp, this.showCandF(this.dimmN1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmO1Temp), DIMM_O1_Temp, this.showCandF(this.dimmO1Temp), "N/A", "" + this.showCandF((byte)85)));
        list.add(this.createTemperatureData(this.checkDIMMTemp(this.dimmP1Temp), DIMM_P1_Temp, this.showCandF(this.dimmP1Temp), "N/A", "" + this.showCandF((byte)85)));
        return list;
    }

    @Override
    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU1Temp() < this.getCpu1TempLimit()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU2Temp() < this.getCpu2TempLimit()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkRemoteCPU3Temp() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU3Temp() < this.getCpu3TempLimit()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkRemoteCPU4Temp() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 2;
        }
        if (this.getRemoteCPU4Temp() < this.getCpu4TempLimit()) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkSystemTemp() {
        if (this.getSystemTemp() < this.cpu1TempLimit) {
            return 0;
        }
        return 1;
    }

    public int checkSystemTemp2() {
        if (this.system2Temp < this.cpu2TempLimit) {
            return 0;
        }
        return 1;
    }

    @Override
    public int checkCpu1CoreVoltage() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu1CoreVoltageFormula() <= this.getCpuCoreVoltageLowLimit() || this.getCpu1CoreVoltageFormula() >= this.getCpuCoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int checkCpu2CoreVoltage() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu2CoreVoltageFormula() <= this.getCpuCoreVoltageLowLimit() || this.getCpu2CoreVoltageFormula() >= this.getCpuCoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu3CoreVoltage() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getCpu3CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu3CoreVoltageFormula() <= this.getCpuCoreVoltageLowLimit() || this.getCpu3CoreVoltageFormula() >= this.getCpuCoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkCpu4CoreVoltage() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 2;
        }
        if (this.getCpu4CoreVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCpu4CoreVoltageFormula() <= this.getCpuCoreVoltageLowLimit() || this.getCpu4CoreVoltageFormula() >= this.getCpuCoreVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMM1Voltage() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 2;
        }
        if (this.getVDIMM1VoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMM1VoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMM1VoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMM2Voltage() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 2;
        }
        if (this.getVDIMM2VoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMM2VoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMM2VoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMM3Voltage() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 2;
        }
        if (this.getVDIMM3VoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMM3VoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMM3VoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkVDIMM4Voltage() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 2;
        }
        if (this.getVDIMM4VoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getVDIMM4VoltageFormula() <= this.getDIMMVoltageLowLimit() || this.getVDIMM4VoltageFormula() >= this.getDIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkV3p3sb() {
        if (this.getV3p3sbFormula() == 0.0) {
            return 2;
        }
        if (this.getV3p3sbFormula() <= this.getV3p3sbLowLimit() || this.getV3p3sbFormula() >= this.getV3p3sbHighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkPCHTemp() {
        if (this.pchTemp < this.getPCHTempHighLimit()) {
            return 0;
        }
        return 1;
    }

    public int checkp1v2() {
        if (this.getV1p2Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p2Formula() <= this.getV1p2LowLimit() || this.getV1p2Formula() >= this.getV1p2HighLimit()) {
            return 1;
        }
        return 0;
    }

    public int checkPower() {
        if (this.pwr == 0) {
            return 2;
        }
        if ((double)this.pwr < this.getPowerHighLimit()) {
            return 0;
        }
        return 1;
    }

    @Override
    public byte getSystemTempHighLimit() {
        return 85;
    }

    public byte getPCHTempHighLimit() {
        return 95;
    }

    public byte getCpu1TempLimit() {
        return this.cpu1TempLimit;
    }

    public byte getCpu2TempLimit() {
        return this.cpu2TempLimit;
    }

    public byte getCpu3TempLimit() {
        return this.cpu3TempLimit;
    }

    public byte getCpu4TempLimit() {
        return this.cpu4TempLimit;
    }

    @Override
    public double getV1p2HighLimit() {
        return 1.21;
    }

    @Override
    public double getV1p2LowLimit() {
        return 0.95;
    }

    public double getV3p3sbHighLimit() {
        return 3.63;
    }

    public double getV3p3sbLowLimit() {
        return 2.96;
    }

    public double getPowerHighLimit() {
        return 1000.0;
    }

    @Override
    public double getBatteryVoltageHighLimit() {
        return 3.63;
    }

    @Override
    public double getBatteryVoltageLowLimit() {
        return 2.97;
    }

    public byte getSystem2Temp() {
        return this.system2Temp;
    }

    public byte getPchTemp() {
        return this.pchTemp;
    }

    public byte getDimmA1Temp() {
        return this.dimmA1Temp;
    }

    public byte getDimmB1Temp() {
        return this.dimmB1Temp;
    }

    public byte getDimmC1Temp() {
        return this.dimmC1Temp;
    }

    public byte getDimmD1Temp() {
        return this.dimmD1Temp;
    }

    public byte getDimmE1Temp() {
        return this.dimmE1Temp;
    }

    public byte getDimmF1Temp() {
        return this.dimmF1Temp;
    }

    public byte getDimmG1Temp() {
        return this.dimmG1Temp;
    }

    public byte getDimmH1Temp() {
        return this.dimmH1Temp;
    }

    public byte getDimmI1Temp() {
        return this.dimmI1Temp;
    }

    public byte getDimmJ1Temp() {
        return this.dimmJ1Temp;
    }

    public byte getDimmK1Temp() {
        return this.dimmK1Temp;
    }

    public byte getDimmL1Temp() {
        return this.dimmL1Temp;
    }

    public byte getDimmM1Temp() {
        return this.dimmM1Temp;
    }

    public byte getDimmN1Temp() {
        return this.dimmN1Temp;
    }

    public byte getDimmO1Temp() {
        return this.dimmO1Temp;
    }

    public byte getDimmP1Temp() {
        return this.dimmP1Temp;
    }

    public void setVDIMM1Voltage(byte VDIMM1Voltage) {
        this.vDIMM1Voltage = VDIMM1Voltage;
    }

    public void setVDIMM2Voltage(byte VDIMM2Voltage) {
        this.vDIMM2Voltage = VDIMM2Voltage;
    }

    public void setVDIMM3Voltage(byte VDIMM3Voltage) {
        this.vDIMM3Voltage = VDIMM3Voltage;
    }

    public void setVDIMM4Voltage(byte VDIMM4Voltage) {
        this.vDIMM4Voltage = VDIMM4Voltage;
    }

    public void setCpu3CoreVoltage(byte cpu3CoreVoltage) {
        this.cpu3CoreVoltage = cpu3CoreVoltage;
    }

    public void setCpu4CoreVoltage(byte cpu4CoreVoltage) {
        this.cpu4CoreVoltage = cpu4CoreVoltage;
    }

    @Override
    public double getV1p2Formula() {
        return (double)(this.v1p2 & 0xFF) * 0.008 * 2.0;
    }

    @Override
    public double getV5sbFormula() {
        return (double)(this.v5sb & 0xFF) * 0.008 * 4.0 * 2.0;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.008 * 4.0 * 2.0;
    }

    @Override
    public double getCpu1CoreVoltageFormula() {
        if (this.getRemoteCPU1Temp() == -127) {
            return 0.0;
        }
        return (double)(this.cpu1CoreVoltage & 0xFF) * 0.016;
    }

    public double getCpuCoreVoltageHighLimit() {
        return 1.54;
    }

    public double getCpuCoreVoltageLowLimit() {
        return 0.6;
    }

    @Override
    public double getCpu2CoreVoltageFormula() {
        if (this.getRemoteCPU2Temp() == -127) {
            return 0.0;
        }
        return (double)(this.cpu2CoreVoltage & 0xFF) * 0.016;
    }

    public double getCpu3CoreVoltageFormula() {
        if (this.getRemoteCPU3Temp() == -127) {
            return 0.0;
        }
        return (double)(this.cpu3CoreVoltage & 0xFF) * 0.016;
    }

    public double getCpu4CoreVoltageFormula() {
        if (this.getRemoteCPU4Temp() == -127) {
            return 0.0;
        }
        return (double)(this.cpu4CoreVoltage & 0xFF) * 0.016;
    }

    @Override
    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.024 * 2.0;
    }

    @Override
    public double getV3p3Formula() {
        return (double)(this.v3p3 & 0xFF) * 0.024 * 2.0;
    }

    public double getVDIMM1VoltageFormula() {
        return (double)(this.vDIMM1Voltage & 0xFF) * 0.016;
    }

    public double getVDIMM2VoltageFormula() {
        return (double)(this.vDIMM2Voltage & 0xFF) * 0.016;
    }

    public double getVDIMM3VoltageFormula() {
        return (double)(this.vDIMM3Voltage & 0xFF) * 0.016;
    }

    public double getVDIMM4VoltageFormula() {
        return (double)(this.vDIMM4Voltage & 0xFF) * 0.016;
    }

    @Override
    public double getV12Formula() {
        return 2.0 * ((double)(this.v12 & 0xFF) * 0.008 / 0.1510574018126888);
    }

    public double getDIMMVoltageLowLimit() {
        return 1.15;
    }

    public double getDIMMVoltageHighLimit() {
        return 1.65;
    }

    public double getV3p3sbFormula() {
        return (double)(this.v3p3sb & 0xFF) * 0.024 * 2.0;
    }

    public double getPwr() {
        return this.pwr & 0xFF;
    }
}

