/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMITwinProCommand;
import com.supermicro.ipmi.MCUType;
import com.supermicro.ipmi.text.MOut;

abstract class MCUUpdateInterface {
    IPMITwinProCommand ipmiTwinProComm;
    MOut mout;
    byte[] mcuFirmware;
    String mcuFirmwareName;
    byte[] ver = new byte[]{36, 86, 69, 82};
    MCUType mcuType;

    MCUUpdateInterface() {
    }

    public void setIpmiTwinProComm(IPMITwinProCommand ipmiTwinProComm) {
        this.ipmiTwinProComm = ipmiTwinProComm;
    }

    public void setMCUFirmware(byte[] fileByteArray) {
        this.mcuFirmware = fileByteArray;
    }

    public void setMout(MOut mout) {
        this.mout = mout;
    }

    public MCUType getMcuType() {
        return this.mcuType;
    }

    public void setMcuType(MCUType mcuType) {
        this.mcuType = mcuType;
    }

    abstract boolean validatePrerequisites();

    abstract boolean verifyFileFormat();

    boolean isNodesShutdown() {
        try {
            for (int i = 1; i < this.ipmiTwinProComm.getTwinProMCU().nodeSize; ++i) {
                if (!"Active".equals(this.ipmiTwinProComm.getTwinProMCU().displayPsonString((byte)i))) continue;
                this.mout.println("Please power off other nodes.");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    String notifiyMessage(MCUType mcuType) {
        if (mcuType == null) {
            return "Rebooting-System, Please wait...";
        }
        switch (mcuType) {
            case EC: 
            case CPLD: {
                return "Please do AC Power Cycle and BMC will reset immediately.";
            }
        }
        return "Rebooting-System, Please wait...";
    }

    int indexOf(byte[] outerArray, byte[] smallerArray) {
        for (int i = 0; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }
}

