/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.common.java.util;

import com.zerog.common.java.lang.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertiesUtil {
    public static void listProperties(PrintStream printStream, Properties properties) {
        String[] stringArray = StringUtil.orderStrings(properties.propertyNames(), (boolean)false);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            printStream.println(string + "=" + properties.getProperty(string));
        }
    }

    public static Properties mergeProps(Properties properties, Properties properties2) {
        Properties properties3 = (Properties)properties.clone();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties3.put(string, properties2.getProperty(string));
        }
        return properties3;
    }

    public static void mergeIntoProps(Properties properties, Properties properties2) {
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, properties2.getProperty(string));
        }
    }

    public static Properties loadProperties(File file) {
        String string = System.getProperty("java.version");
        Properties properties = new Properties();
        try {
            if (string.contains("1.5")) {
                FileInputStream fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                ((InputStream)fileInputStream).close();
            } else {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                properties.load(bufferedReader);
                bufferedReader.close();
            }
            return properties;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

